/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.action.SwitchDraftMarkAction;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.Draftable;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import org.jetbrains.annotations.NotNull;

public class DraftableEditor
extends FlowNodePropertiesEditor {
    private DraftEditorBuilder builder;

    public DraftableEditor(@NotNull Draftable draftable, @NotNull AbstractFlowNodePropertiesPanel.ChangeTypeListener rebuildListener) {
        this.builder = new DraftEditorBuilder(draftable, rebuildListener);
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    private static class DraftEditorBuilder
    extends DefaultEditorBuilder {
        private List<EditorBuilder.RowBuilder> rowBuilders = new ArrayList<EditorBuilder.RowBuilder>();

        public DraftEditorBuilder(final @NotNull Draftable draftable, final @NotNull AbstractFlowNodePropertiesPanel.ChangeTypeListener rebuildListener) {
            this.rowBuilders.add(new DefaultRowEditorBuilder(DesignerMsg.IS_DRAFT){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    final CheckBox mockedCheckBox = CheckBox.create((UiContainer)parent);
                    mockedCheckBox.setSelected(draftable.isDraft());
                    mockedCheckBox.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            SwitchDraftMarkAction action = new SwitchDraftMarkAction(draftable);
                            action.run();
                            mockedCheckBox.setSelected(draftable.isDraft());
                            rebuildListener.changed();
                        }
                    });
                    return mockedCheckBox;
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.rowBuilders;
        }

        public void applyChanges() {
        }
    }
}

