/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.flowpanels.DataAssociationsPanelOptions;
import oracle.bpm.designer.flowpanels.ElementsLinkEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.project.model.processes.Draftable;
import oracle.bpm.project.model.processes.InputDataAssociationEnabled;
import oracle.bpm.project.model.processes.OutputDataAssociationEnabled;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class DataAssociationsLinkEditor
extends ElementsLinkEditor
implements EditableComponent<DataAssociationEnabled> {
    private DataAssociationEnabled dataAssociationEnabled;

    public DataAssociationsLinkEditor(@NotNull UiContainer parent, @NotNull DataAssociationEnabled dataAssociationEnabled) {
        super(parent, DesignerMsg.DATA_ASSOCIATIONS, Image.create((Msg)DesignerMsg.DATA_ASSOCIATIONS));
        this.dataAssociationEnabled = dataAssociationEnabled;
        this.initialize();
    }

    @Override
    public void validateEditor() throws ProjectException {
    }

    @Override
    public void applyChanges() {
    }

    @Override
    public void populateValues() {
    }

    @Override
    public void loadValues() {
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public DataAssociationEnabled getElement() {
        return this.dataAssociationEnabled;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setElement(DataAssociationEnabled element) {
        this.dataAssociationEnabled = element;
    }

    @Override
    protected boolean hasElements() {
        return this.dataAssociationEnabled.hasDataAssociations();
    }

    @Override
    protected void clearElements() {
        if (MessageDialog.showQuestion((Msg)DesignerMsg.DATA_ASSOCIATIONS, (Msg)DesignerMsg.CONFIRM_DATA_ASSOCIATIONS_UNCHECK, (int)6) == 2) {
            this.clearDataAssociations();
        }
    }

    @Override
    protected void editElements() {
        if (this.getOutputDataAssociationSet() == null && !this.hasArguments()) {
            MessageDialog.showNotice((Msg)DesignerMsg.DATA_ASSOCIATION_NO_ARGUMENTS);
            return;
        }
        DataAssociationsPanelOptions options = new DataAssociationsPanelOptions();
        boolean isDraft = this.dataAssociationEnabled.isDraftable() && ((Draftable)this.dataAssociationEnabled.asAnyNode(Draftable.class)).isDraft();
        options.setDraft(isDraft);
        Dialog dialog = AbstractStudioWorkbench.getInstance().getDataAssociationMapDialog(this.getOwnerWindow(), this.dataAssociationEnabled, options);
        if (dialog != null) {
            dialog.setVisible(true);
        }
    }

    private void clearDataAssociations() {
        this.dataAssociationEnabled.clearDataAssociations();
    }

    private boolean hasArguments() {
        return this.getInputDataAssociationSet() != null && !this.getInputDataAssociationSet().getArgumentsContainer().getDeclarations().isEmpty() || this.getOutputDataAssociationSet() != null && !this.getOutputDataAssociationSet().getArgumentsContainer().getDeclarations().isEmpty();
    }

    private DataAssociationSet getInputDataAssociationSet() {
        if (this.dataAssociationEnabled.isInputDataAssociationEnabled()) {
            return ((InputDataAssociationEnabled)this.dataAssociationEnabled).getInputDataAssociationSet();
        }
        return null;
    }

    private DataAssociationSet getOutputDataAssociationSet() {
        if (this.dataAssociationEnabled.isOutputDataAssociationEnabled()) {
            return ((OutputDataAssociationEnabled)this.dataAssociationEnabled).getOutputDataAssociationSet();
        }
        return null;
    }
}

