/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.panels.builder.EditableComponentPanel;
import oracle.bpm.lang.Any;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.InstantiateFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class CreateInstanceComponentAdapter
extends EditableComponentPanel<ReceiveTask> {
    private CheckBox createInstanceCheck;
    private boolean showLabel = false;
    private InstantiateFeature taskFeature;

    public CreateInstanceComponentAdapter(@NotNull UiContainer parent, @NotNull ReceiveTask receiveTask) {
        this(parent, receiveTask, false);
    }

    public CreateInstanceComponentAdapter(@NotNull UiContainer parent, @NotNull ReceiveTask receiveTask, boolean showLabel) {
        super(parent, receiveTask);
        this.showLabel = showLabel;
        this.taskFeature = (InstantiateFeature)receiveTask.getFeature(InstantiateFeature.class);
        this.buildUi();
    }

    public void buildUi() {
        this.setLayout((Layout)new MigLayout("fillx"));
        this.createInstanceCheck = new CheckBox((UiContainer)this);
        this.populateValues();
        if (this.showLabel) {
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectModelMsg.BPEL_CREATE_INSTANCE));
        }
        this.add((UiComponent)this.createInstanceCheck, "growx");
    }

    @Override
    public void validateEditor() throws ProjectException {
    }

    @Override
    public void applyChanges() {
        this.taskFeature.setValue(Boolean.valueOf(this.createInstanceCheck.isSelected()));
    }

    @Override
    public boolean isDirty() {
        return !Any.equals(this.taskFeature.getValue(), this.createInstanceCheck.isSelected());
    }

    @Override
    public void populateValues() {
        this.loadValues();
    }

    @Override
    public void loadValues() {
        this.createInstanceCheck.setSelected(this.taskFeature.getValue().booleanValue());
    }
}

