/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.Collections;
import java.util.List;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.measurementmark.CounterPropertiesPanel;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;

class CounterEditor
extends FlowNodePropertiesEditor {
    private CounterEditorBuilder builder;

    public CounterEditor(Counter counter) {
        this.builder = new CounterEditorBuilder(counter);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private class CounterEditorBuilder
    extends DefaultEditorBuilder {
        private Counter counter;
        private CounterPropertiesPanel panel;

        public CounterEditorBuilder(Counter counter) {
            this.counter = counter;
        }

        public void applyChanges() {
            try {
                this.panel.editorToObject();
            }
            catch (ProjectException e) {
                e.printStackTrace();
                MessageDialog.showError((Throwable)e);
            }
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            DefaultRowEditorBuilder singleton = new DefaultRowEditorBuilder(null){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    CounterEditorBuilder.this.panel = new CounterPropertiesPanel(parent, CounterEditorBuilder.this.counter);
                    CounterEditorBuilder.this.panel.objectToEditor(CounterEditorBuilder.this.counter);
                    return CounterEditorBuilder.this.panel;
                }
            };
            return Collections.singletonList(singleton);
        }
    }
}

