/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.AbstractCompositeEditor;
import oracle.bpm.designer.flowpanels.CounterEditor;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.FlowNode;

class CounterCompositeEditor
extends AbstractCompositeEditor {
    public CounterCompositeEditor(FlowNode node) {
        super(DesignerMsg.COUNTER, node);
    }

    public static CounterCompositeEditor create(FlowNode flowNode) {
        return new CounterCompositeEditor(flowNode);
    }

    @Override
    protected List<FlowNodePropertiesEditor> buildEditors() {
        ArrayList<FlowNodePropertiesEditor> result = new ArrayList<FlowNodePropertiesEditor>();
        Counter counter = this.findCounterAssociated(this.getFlowNode());
        if (counter != null) {
            result.add(new CounterEditor(counter));
        }
        return result;
    }

    private Counter findCounterAssociated(FlowNode flowNode) {
        for (Counter counter : flowNode.getProcess().getCounters()) {
            if (counter.getActivity() == null || !flowNode.getId().equals(counter.getActivity().getId())) continue;
            return counter;
        }
        return null;
    }
}

