/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.correlation.CorrelationDialog;
import oracle.bpm.designer.flowpanels.ElementsLinkEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class CorrelationsSelectorPanel
extends Panel
implements EditableComponent<CorrelationsEnabled> {
    private CorrelationsEnabled correlationsEnabled;

    public CorrelationsSelectorPanel(@NotNull UiContainer parent, @NotNull CorrelationsEnabled correlationsEnabled) {
        super(parent);
        this.correlationsEnabled = correlationsEnabled;
        this.init();
    }

    @Override
    public void validateEditor() throws ProjectException {
    }

    @Override
    public void applyChanges() {
    }

    @Override
    public void populateValues() {
    }

    @Override
    public void loadValues() {
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public CorrelationsEnabled getElement() {
        return this.correlationsEnabled;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setElement(CorrelationsEnabled element) {
        this.correlationsEnabled = element;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0"));
        this.add((UiComponent)this.createCorrelationsLinkEditor((UiContainer)this));
    }

    private ElementsLinkEditor createCorrelationsLinkEditor(@NotNull UiContainer parent) {
        ElementsLinkEditor result = new ElementsLinkEditor(parent, ProjectMsg.CORRELATIONS, Image.create((Msg)ProjectMsg.CORRELATIONS)){

            @Override
            protected boolean hasElements() {
                return CorrelationsSelectorPanel.this.hasCorrelations();
            }

            @Override
            protected void clearElements() {
                if (MessageDialog.showQuestion((Msg)ProjectMsg.CORRELATIONS, (Msg)DesignerMsg.CONFIRM_CORRELATIONS_UNCHECK, (int)6) == 2) {
                    CorrelationsSelectorPanel.this.clearCorrelations();
                }
            }

            @Override
            protected void editElements() {
                if (!CorrelationsSelectorPanel.this.isCorrelationsEnabled()) {
                    MessageDialog.showNotice((Msg)DesignerMsg.CORRELATION_NO_ARGUMENTS);
                    return;
                }
                CorrelationDialog d = new CorrelationDialog(this.getOwnerWindow(), CorrelationsSelectorPanel.this.correlationsEnabled);
                d.setVisible(true);
            }
        };
        result.initialize();
        return result;
    }

    private void clearCorrelations() {
        this.correlationsEnabled.clearCorrelations();
    }

    private boolean hasCorrelations() {
        return this.correlationsEnabled.hasCorrelations();
    }

    private boolean isCorrelationsEnabled() {
        return this.correlationsEnabled.isInputCorrelationsEnabled() || this.correlationsEnabled.isOutputCorrelationsEnabled();
    }
}

