/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;

class ComplexGatewayEditor
extends FlowNodePropertiesEditor {
    private ComplexGatewayEditorBuilder builder;

    public ComplexGatewayEditor(ComplexGateway gateway) {
        this.builder = new ComplexGatewayEditorBuilder(gateway);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class ComplexGatewayEditorBuilder
    extends DefaultEditorBuilder {
        private CheckBox abortCheckbox;
        private List<EditorBuilder.RowBuilder> builders;
        private ComplexGateway complexGateway;
        private ExpressionPanel expressionPanel;

        public ComplexGatewayEditorBuilder(final ComplexGateway complexGateway) {
            this.complexGateway = complexGateway;
            this.builders = new ArrayList<EditorBuilder.RowBuilder>();
            this.builders.add(new DefaultRowEditorBuilder(DesignerMsg.EXPRESSION){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    Panel container = new Panel(parent);
                    container.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
                    CatalogType resultType = CatalogType.Default.getBool();
                    ComplexGatewayEditorBuilder.this.expressionPanel = ExpressionPanelFactory.createDefaultMultiLinePanel(parent, new ExpressionContext((DataDeclarationContainer)complexGateway, resultType));
                    ComplexGatewayEditorBuilder.this.expressionPanel.setExpression(complexGateway.getActivationCondition());
                    container.add(ComplexGatewayEditorBuilder.this.expressionPanel.getUiComponent(), (Object)"growx, height 100!, wrap");
                    ComplexGatewayEditorBuilder.this.abortCheckbox = CheckBox.create((UiContainer)container, (Msg)DesignerMsg.ABORT_PENDING_FLOWS);
                    ComplexGatewayEditorBuilder.this.abortCheckbox.setSelected(complexGateway.isAbortPendingFlows());
                    container.add((UiComponent)ComplexGatewayEditorBuilder.this.abortCheckbox);
                    return container;
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            ComplexGateway gateway = this.getComplexGateway();
            gateway.setActivationCondition(this.expressionPanel.getExpression());
            gateway.setAbortPendingFlows(this.abortCheckbox.isSelected());
        }

        private ComplexGateway getComplexGateway() {
            return this.complexGateway;
        }
    }
}

