/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.draw.Font;
import oracle.bpm.lang.Any;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractLabelProvider;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;

public class CallActivityPanel
extends Panel
implements EditableComponent<CallActivity> {
    private CallActivity callActivity;
    private ArrayList<Process> cicleList;
    private ComboBox<Process> processesCombo;
    private ArrayList<Process> processList;
    private boolean showLabel = false;

    public CallActivityPanel(UiContainer parent, CallActivity callActivity) {
        this(parent, callActivity, false);
    }

    public CallActivityPanel(UiContainer parent, CallActivity callActivity, boolean showLabel) {
        super(parent);
        this.callActivity = callActivity;
        this.showLabel = showLabel;
        this.buildUi();
    }

    public void buildUi() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
        Button resetButton = Button.createIconic((UiContainer)this, (Msg)UIMsg.CLEAR);
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CallActivityPanel.this.processesCombo.setSelectedItem(null);
            }
        });
        this.initProcessList();
        this.processesCombo = UiFactory.createComboBox((UiContainer)this, this.processList);
        this.processesCombo.setLabelProvider((LabelProvider)new AbstractLabelProvider<Process>(){

            public String getText(Process element) {
                String text = element.getDefaultLabel();
                if (CallActivityPanel.this.cicleList.contains(element)) {
                    text = DesignerMsg.PROCESS_WILL_FORM_CICLE(text).toString();
                }
                return text;
            }

            public Image getIcon(Process element) {
                Image result = CallActivityPanel.this.cicleList.contains(element) ? Image.create((Msg)DesignerMsg.FORBIDDEN) : null;
                return result;
            }
        });
        this.processesCombo.setFontProvider((FontProvider)new FontProvider<Process>(){

            public Font getFont(Process element) {
                Font result = CallActivityPanel.this.processesCombo.getFont();
                if (CallActivityPanel.this.cicleList.contains(element)) {
                    result = result.italic();
                }
                return result;
            }
        });
        this.processesCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CallActivityPanel.this.applyChanges();
            }
        });
        this.processesCombo.setSelectedItem((Object)this.callActivity.getCalledElement());
        if (this.showLabel) {
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.PROCESS));
        }
        this.add((UiComponent)this.processesCombo, "growx");
        this.add((UiComponent)resetButton, "wrap");
    }

    @Override
    public void validateEditor() throws ProjectException {
        Process process = (Process)this.processesCombo.getSelectedItem();
        if (this.cicleList.contains(process)) {
            throw new ProjectException((ProjectObject)this.callActivity, DesignerMsg.PROCESS_CAN_NOT_BE_CHOOSEN_CICLE_MIGHT_BE_PRODUCED(process.getDefaultLabel()));
        }
    }

    @Override
    public void applyChanges() {
        Process process = (Process)this.processesCombo.getSelectedItem();
        this.callActivity.setCalledElement(process);
    }

    @Override
    public void populateValues() {
        this.initProcessList();
        this.processesCombo.removeAllItems();
        this.processesCombo.addItems(this.processList);
        this.loadValues();
    }

    @Override
    public void loadValues() {
        this.processesCombo.setSelectedItem((Object)this.callActivity.getCalledElement());
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public CallActivity getElement() {
        return this.callActivity;
    }

    @Override
    public boolean isDirty() {
        return !Any.equals(this.callActivity.getCalledElement(), this.processesCombo.getSelectedItem());
    }

    @Override
    public void setElement(CallActivity element) {
        this.callActivity = element;
    }

    private void initProcessList() {
        this.processList = new ArrayList();
        this.cicleList = new ArrayList();
        Process current = this.callActivity.getProcess();
        Collection processes = this.callActivity.getProject().getProcesses();
        for (Process process : processes) {
            if (process.equals(current) || !process.isCallableSubprocess()) continue;
            if (ModelUtils.getCalledProcesses((Process)process).contains(current)) {
                this.cicleList.add(process);
            }
            this.processList.add(process);
        }
    }
}

