/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.BusinessRuleData;
import oracle.bpm.designer.BusinessRuleService;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.OperationRowEditorBuilder;
import oracle.bpm.designer.flowpanels.SoaObjectRowEditorBuilder;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogArgument;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiWindow;
import org.jetbrains.annotations.Nullable;

class BusinessRuleTaskEditor
extends FlowNodePropertiesEditor {
    private BusinessRuleTaskImplementationEditorBuilder builder;

    public BusinessRuleTaskEditor(BusinessRuleTask businessRuleTask) {
        this.builder = new BusinessRuleTaskImplementationEditorBuilder(businessRuleTask);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class BusinessRuleTaskImplementationEditorBuilder
    extends DefaultEditorBuilder {
        private BusinessRule businessRule;
        private BusinessRuleTask businessRuleTask;
        private CatalogMember operation;
        private List<EditorBuilder.RowBuilder> rowBuilders = new ArrayList<EditorBuilder.RowBuilder>();

        public BusinessRuleTaskImplementationEditorBuilder(final BusinessRuleTask businessRuleTask) {
            this.businessRuleTask = businessRuleTask;
            this.businessRule = businessRuleTask.getBusinessRule();
            this.operation = businessRuleTask.getFunction();
            final OperationRowEditorBuilder operationRowEditorBuilder = new OperationRowEditorBuilder(ProjectMsg.DECISION_FUNCTION, (CatalogObject)this.businessRule, this.operation){

                @Override
                protected void change(CatalogMember newValue) {
                    BusinessRuleTaskImplementationEditorBuilder.this.operation = newValue;
                    BusinessRuleTaskImplementationEditorBuilder.this.applyChanges();
                }
            };
            StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
            final BusinessRuleService service = workbench.getBusinessRuleService();
            SoaObjectRowEditorBuilder<BusinessRule> catalogObjectRowEditorBuilder = new SoaObjectRowEditorBuilder<BusinessRule>(ProjectMsg.BUSINESS_RULE, businessRuleTask.getProject(), ProjectFilters.BUSINESS_RULES, this.businessRule){

                @Override
                protected void change(BusinessRule newValue) {
                    BusinessRuleTaskImplementationEditorBuilder.this.businessRule = newValue;
                    operationRowEditorBuilder.setParticipant((CatalogObject)newValue);
                    BusinessRuleTaskImplementationEditorBuilder.this.applyChanges();
                }

                @Override
                protected Msg getBrowseTitle() {
                    return DesignerMsg.BROWSE_BUSINESS_RULES;
                }

                @Override
                protected void addAction(UiWindow parent) {
                    BusinessRule newBusinessRule;
                    BusinessRuleData businessRuleData = service.createBusinessRule(parent, (FlowNode)businessRuleTask);
                    if (businessRuleData != null && (newBusinessRule = businessRuleData.getBusinessRule()) != null) {
                        this.changeValue((CatalogObject)newBusinessRule);
                        CatalogMember operation = businessRuleTask.getFunction();
                        if (operation != null) {
                            Sequence arguments = operation.getArguments();
                            Sequence fixInputParameters = BusinessRuleTaskImplementationEditorBuilder.fixInputParameters(arguments, businessRuleData.getInputParameters());
                            Sequence fixOutputParameters = BusinessRuleTaskImplementationEditorBuilder.fixOutputParameters(arguments, businessRuleData.getOutputParameters());
                            DataAssociationSet inputDataAssociationSet = businessRuleTask.getInputDataAssociationSet();
                            2.changeDataAssociation(inputDataAssociationSet, fixInputParameters);
                            DataAssociationSet outputDataAssociationSet = businessRuleTask.getOutputDataAssociationSet();
                            2.changeDataAssociation(outputDataAssociationSet, fixOutputParameters);
                        }
                    }
                }
            };
            this.rowBuilders.add(catalogObjectRowEditorBuilder);
            this.rowBuilders.add(operationRowEditorBuilder);
        }

        public void applyChanges() {
            this.businessRuleTask.setBusinessRule(this.businessRule);
            CatalogMember newOperation = this.businessRule == null ? null : this.operation;
            this.businessRuleTask.setFunction(newOperation);
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.rowBuilders;
        }

        private static Sequence<Tuple<String, String>> fixInputParameters(Sequence<CatalogArgument> arguments, Sequence<Tuple<String, String>> inputParameters) {
            ArrayList<Tuple<String, String>> result = new ArrayList<Tuple<String, String>>();
            Sequence<CatalogArgument> inArguments = BusinessRuleTaskImplementationEditorBuilder.getArguments(arguments, true);
            for (CatalogArgument inArgument : inArguments) {
                String inArgumentName = inArgument.getName();
                String inArgumentNativeName = inArgument.getNativeName();
                String source = BusinessRuleTaskImplementationEditorBuilder.findSourceForInputArgument(inArgumentNativeName, inputParameters);
                if (source == null) continue;
                Tuple<String, String> fixedTuple = Tuple.create(source, inArgumentName);
                result.add(fixedTuple);
            }
            return CollectionUtils.asSequence(result);
        }

        private static String findSourceForInputArgument(String argument, Sequence<Tuple<String, String>> inputParameters) {
            String result = null;
            for (Tuple<String, String> tuple : inputParameters) {
                if (!argument.equals(tuple.getSecond())) continue;
                result = tuple.getFirst();
                break;
            }
            return result;
        }

        private static Sequence<Tuple<String, String>> fixOutputParameters(Sequence<CatalogArgument> arguments, Sequence<Tuple<String, String>> outputParameters) {
            ArrayList<Tuple<String, String>> result = new ArrayList<Tuple<String, String>>();
            Sequence<CatalogArgument> outArguments = BusinessRuleTaskImplementationEditorBuilder.getArguments(arguments, false);
            for (CatalogArgument outArgument : outArguments) {
                String outArgumentName = outArgument.getName();
                String outArgumentNativeName = outArgument.getNativeName();
                String target = BusinessRuleTaskImplementationEditorBuilder.findTargetForOutputArgument(outArgumentNativeName, outputParameters);
                if (target == null) continue;
                Tuple<String, String> fixedTuple = Tuple.create(outArgumentName, target);
                result.add(fixedTuple);
            }
            return CollectionUtils.asSequence(result);
        }

        private static String findTargetForOutputArgument(String argument, Sequence<Tuple<String, String>> outputParameters) {
            String result = null;
            for (Tuple<String, String> tuple : outputParameters) {
                if (!argument.equals(tuple.getFirst())) continue;
                result = tuple.getSecond();
                break;
            }
            return result;
        }

        private static Sequence<CatalogArgument> getArguments(Sequence<CatalogArgument> arguments, final boolean in) {
            return arguments.select(new Predicate<CatalogArgument>(){

                @Override
                public boolean check(@Nullable CatalogArgument value) {
                    return value != null && in == value.isIn();
                }
            });
        }
    }
}

