/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.Collections;
import java.util.List;
import oracle.bpm.designer.bpa.AnnotationsTableModel;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import org.jetbrains.annotations.NotNull;

class AnnotationsTableEditor
extends FlowNodePropertiesEditor {
    private AnnotationsTableEditorBuilder builder;

    public AnnotationsTableEditor(@NotNull FlowNode flowNode) {
        this.builder = new AnnotationsTableEditorBuilder(flowNode);
    }

    @Override
    public void applyChanges() {
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class AnnotationsTableEditorBuilder
    extends DefaultEditorBuilder {
        private EditorBuilder.RowBuilder builder;

        public AnnotationsTableEditorBuilder(final @NotNull FlowNode flowNode) {
            this.builder = new DefaultRowEditorBuilder(null){

                @Override
                public boolean isGrowX() {
                    return false;
                }

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    Panel annotations = new Panel(parent);
                    annotations.setLayout((Layout)new BorderLayout());
                    Table table = new Table((UiContainer)annotations){

                        protected boolean contributesToEdition() {
                            return false;
                        }
                    };
                    table.setPreferredRows(10);
                    table.setAutoResizeMode(AutoResizeMode.ALL_COLUMNS);
                    table.setModel((TableModel)new AnnotationsTableModel(flowNode));
                    annotations.add((UiComponent)table, (Object)"Center");
                    return annotations;
                }
            };
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return Collections.singletonList(this.builder);
        }
    }
}

