/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

class AllowsInterruptionsEditor
extends FlowNodePropertiesEditor {
    private AllowsInterruptionsEditorBuilder builder;

    public AllowsInterruptionsEditor(@NotNull StartEvent event) {
        this.builder = new AllowsInterruptionsEditorBuilder(event);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class AllowsInterruptionsEditorBuilder
    extends DefaultEditorBuilder {
        private List<EditorBuilder.RowBuilder> builders;
        private StartEvent event;
        private CheckBox interrupts;

        private AllowsInterruptionsEditorBuilder(final @NotNull StartEvent event) {
            this.event = event;
            this.builders = new ArrayList<EditorBuilder.RowBuilder>();
            this.builders.add(new DefaultRowEditorBuilder(DesignerMsg.EMPTY_MSG("")){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    AllowsInterruptionsEditorBuilder.this.interrupts = CheckBox.create((UiContainer)parent, (Msg)ProjectModelMsg.ALLOWS_INTERRUPTIONS);
                    AllowsInterruptionsEditorBuilder.this.interrupts.setSelected(event.isInterrupting());
                    return AllowsInterruptionsEditorBuilder.this.interrupts;
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        private void applyChanges() {
            this.getStartEvent().setIsInterrupting(this.interrupts.isSelected());
        }

        private StartEvent getStartEvent() {
            return this.event;
        }
    }
}

