/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.flowpanels.AbstractCompositeEditor;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.designer.flowpanels.ActivityImplementationEditor;
import oracle.bpm.designer.flowpanels.AdvancedEditor;
import oracle.bpm.designer.flowpanels.AnnotationsEditor;
import oracle.bpm.designer.flowpanels.AssociationTaskEditor;
import oracle.bpm.designer.flowpanels.CorrelationsEditor;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.LogHandlersEditor;
import oracle.bpm.designer.flowpanels.MultipleLinksPropertiesEditor;
import oracle.bpm.designer.flowpanels.PropertiesSheet;
import oracle.bpm.designer.flowpanels.UserTaskPreferencesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import oracle.bpm.project.model.processes.loghandlers.Loggable;
import oracle.bpm.project.msg.ProjectMsg;
import org.jetbrains.annotations.NotNull;

class ActivityPropertiesPanel
extends AbstractFlowNodePropertiesPanel {
    public ActivityPropertiesPanel(@NotNull Activity activity) {
        super((FlowNode)activity);
    }

    @NotNull
    public Activity getFlowNode() {
        return (Activity)super.getFlowNode();
    }

    @Override
    protected String getFlowNodeHelpId() {
        return this.getFlowNode().getBpmnType().name();
    }

    @Override
    protected PropertiesSheet createImplementationSheet(AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        PropertiesSheet result = new PropertiesSheet(ProjectMsg.IMPLEMENTATION);
        Activity activity = this.getFlowNode();
        result.addCompositeEditor(ActivityImplementationEditor.create(activity, changeTypeListener));
        if (activity.isUserTask()) {
            final UserTask userTask = (UserTask)activity;
            UserTaskPreferencesEditor preferencesEditor = new UserTaskPreferencesEditor(userTask);
            result.addCompositeEditor(preferencesEditor.getMsg(), preferencesEditor);
            AdvancedEditor advancedEditor = AdvancedEditor.create((FlowNode)activity);
            result.addCompositeEditor(advancedEditor.getMsg(), advancedEditor);
            result.addCompositeEditor(new AbstractCompositeEditor(DesignerMsg.DATA_ASSOCIATIONS, (FlowNode)activity){

                @Override
                protected List<FlowNodePropertiesEditor> buildEditors() {
                    ArrayList<FlowNodePropertiesEditor> result = new ArrayList<FlowNodePropertiesEditor>();
                    MultipleLinksPropertiesEditor linksEditor = new MultipleLinksPropertiesEditor();
                    linksEditor.addLinkEditor(new AssociationTaskEditor((DataAssociationEnabled)userTask));
                    linksEditor.addLinkEditor(new CorrelationsEditor((CorrelationsEnabled)userTask));
                    linksEditor.addLinkEditor(new LogHandlersEditor((Loggable)userTask));
                    result.add(linksEditor);
                    return result;
                }

                @Override
                public boolean shouldRender() {
                    return super.shouldRender() && !AbstractStudioWorkbench.getInstance().isBusinessAnalyst();
                }
            });
        }
        AnnotationsEditor annotationsEditor = AnnotationsEditor.create((FlowNode)this.getFlowNode());
        result.addCompositeEditor(annotationsEditor.getMsg(), annotationsEditor);
        return result;
    }
}

