/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.designer.flowpanels.ActivityChageTypeEditor;
import oracle.bpm.designer.flowpanels.AssociationTaskEditor;
import oracle.bpm.designer.flowpanels.BusinessRuleTaskEditor;
import oracle.bpm.designer.flowpanels.CallActivityEditor;
import oracle.bpm.designer.flowpanels.ConversationalEditor;
import oracle.bpm.designer.flowpanels.CorrelationsEditor;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.ImplementationEditor;
import oracle.bpm.designer.flowpanels.LogHandlersEditor;
import oracle.bpm.designer.flowpanels.MessageHeadersEditor;
import oracle.bpm.designer.flowpanels.MultipleLinksPropertiesEditor;
import oracle.bpm.designer.flowpanels.NotificationTaskEditor;
import oracle.bpm.designer.flowpanels.ReceiveTaskSpecificEditor;
import oracle.bpm.designer.flowpanels.ServicePropertiesEditor;
import oracle.bpm.designer.flowpanels.UpdateTaskEditor;
import oracle.bpm.designer.flowpanels.UserTaskEditor;
import oracle.bpm.project.model.features.ActivityPermissionFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.activities.ActivityPermissionType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.correlations.CorrelationsEnabled;
import oracle.bpm.project.model.processes.loghandlers.Loggable;
import oracle.bpm.project.model.processes.messageheaders.MessageHeadersEnabled;
import oracle.bpm.project.model.processes.notification.NotificationTask;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertiesEnabled;
import oracle.bpm.project.model.processes.update.UpdateTask;
import oracle.bpm.project.model.util.ModelUtils;

class ActivityImplementationEditor
extends ImplementationEditor {
    private ActivityImplementationEditor(Activity activity, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        super((FlowNode)activity, changeTypeListener);
    }

    public static ActivityImplementationEditor create(Activity activity, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        return new ActivityImplementationEditor(activity, changeTypeListener);
    }

    @Override
    public boolean shouldRender() {
        return !ModelUtils.isSubprocess((FlowNode)this.getFlowNode()) && super.shouldRender();
    }

    public Activity getFlowNode() {
        return (Activity)super.getFlowNode();
    }

    @Override
    protected List<FlowNodePropertiesEditor> buildEditors() {
        Activity activity = this.getFlowNode();
        ArrayList<FlowNodePropertiesEditor> editors = new ArrayList<FlowNodePropertiesEditor>();
        editors.add(ActivityChageTypeEditor.create((FlowNode)activity, this.getChangeTypeListener()));
        ActivityPermissionFeature feature = (ActivityPermissionFeature)activity.getFeature(ActivityPermissionFeature.class);
        ActivityPermissionType type = (ActivityPermissionType)feature.getValue();
        boolean shouldRenderImpl = type != ActivityPermissionType.SHOULD_DEFINE;
        MultipleLinksPropertiesEditor linksEditor = new MultipleLinksPropertiesEditor();
        if (activity.isScriptTask()) {
            ScriptTask scriptTask = (ScriptTask)activity.asAnyNode(ScriptTask.class);
            if (shouldRenderImpl) {
                linksEditor.addLinkEditor(new AssociationTaskEditor((DataAssociationEnabled)scriptTask));
                linksEditor.addLinkEditor(new LogHandlersEditor((Loggable)scriptTask));
            }
        } else if (activity.isUserTask()) {
            if (shouldRenderImpl) {
                UserTask userTask = (UserTask)activity.asAnyNode(UserTask.class);
                editors.add(new UserTaskEditor(userTask));
            }
        } else if (activity.isServiceTask()) {
            if (shouldRenderImpl) {
                ServiceTask serviceTask = (ServiceTask)activity.asAnyNode(ServiceTask.class);
                ConversationalEditor conversationalEditor = new ConversationalEditor((Conversational)activity);
                editors.add(conversationalEditor);
                linksEditor.addLinkEditor(new AssociationTaskEditor((DataAssociationEnabled)serviceTask));
                linksEditor.addLinkEditor(new CorrelationsEditor((CorrelationsEnabled)serviceTask));
                linksEditor.addLinkEditor(new LogHandlersEditor((Loggable)serviceTask));
                linksEditor.addLinkEditor(new MessageHeadersEditor((MessageHeadersEnabled)serviceTask));
                linksEditor.addLinkEditor(new ServicePropertiesEditor((ServicePropertiesEnabled)serviceTask));
            }
        } else if (activity.isBusinessRuleTask()) {
            if (shouldRenderImpl) {
                BusinessRuleTask businessRuleTask = (BusinessRuleTask)activity.asAnyNode(BusinessRuleTask.class);
                editors.add(new BusinessRuleTaskEditor(businessRuleTask));
                linksEditor.addLinkEditor(new AssociationTaskEditor((DataAssociationEnabled)businessRuleTask));
                linksEditor.addLinkEditor(new LogHandlersEditor((Loggable)businessRuleTask));
            }
        } else if (activity.isSendTask()) {
            SendTask sendTask = (SendTask)activity.asAnyNode(SendTask.class);
            ConversationalEditor conversationalEditor = new ConversationalEditor((Conversational)activity);
            editors.add(conversationalEditor);
            if (shouldRenderImpl) {
                linksEditor.addLinkEditor(new AssociationTaskEditor((DataAssociationEnabled)sendTask));
                linksEditor.addLinkEditor(new CorrelationsEditor((CorrelationsEnabled)sendTask));
                linksEditor.addLinkEditor(new LogHandlersEditor((Loggable)sendTask));
                linksEditor.addLinkEditor(new MessageHeadersEditor((MessageHeadersEnabled)sendTask));
                linksEditor.addLinkEditor(new ServicePropertiesEditor((ServicePropertiesEnabled)sendTask));
            }
        } else if (activity.isReceiveTask()) {
            ReceiveTask receiveTask = (ReceiveTask)activity.asAnyNode(ReceiveTask.class);
            if (shouldRenderImpl) {
                editors.add(new ReceiveTaskSpecificEditor((ReceiveTask)activity));
            }
            ConversationalEditor conversationalEditor = new ConversationalEditor((Conversational)activity);
            editors.add(conversationalEditor);
            if (shouldRenderImpl) {
                linksEditor.addLinkEditor(new AssociationTaskEditor((DataAssociationEnabled)receiveTask));
                linksEditor.addLinkEditor(new CorrelationsEditor((CorrelationsEnabled)receiveTask));
                linksEditor.addLinkEditor(new LogHandlersEditor((Loggable)receiveTask));
                linksEditor.addLinkEditor(new MessageHeadersEditor((MessageHeadersEnabled)receiveTask));
                linksEditor.addLinkEditor(new ServicePropertiesEditor((ServicePropertiesEnabled)receiveTask));
            }
        } else if (activity.isCallActivity()) {
            CallActivity callActivity = (CallActivity)activity.asAnyNode(CallActivity.class);
            CallActivityEditor callActivityEditor = new CallActivityEditor(callActivity);
            editors.add(callActivityEditor);
            linksEditor.addLinkEditor(new AssociationTaskEditor((DataAssociationEnabled)callActivity));
            linksEditor.addLinkEditor(new LogHandlersEditor((Loggable)callActivity));
        } else if (activity.isNotificationTask()) {
            NotificationTask notificationTask = (NotificationTask)activity.asAnyNode(NotificationTask.class);
            NotificationTaskEditor notificationTaskEditor = new NotificationTaskEditor(notificationTask);
            editors.add(notificationTaskEditor);
        } else if (activity.isUpdateTask()) {
            UpdateTask updateTask = (UpdateTask)activity.asAnyNode(UpdateTask.class);
            UpdateTaskEditor updateTaskEditor = new UpdateTaskEditor(updateTask);
            editors.add(updateTaskEditor);
        }
        if (linksEditor.hasEditors()) {
            editors.add(linksEditor);
        }
        return editors;
    }
}

