/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ActivityGenerateEvents;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.activities.GenerateEventsFeature;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

public class ActivityGenerateEventsFeatureEditor
extends Panel
implements EditableComponent<FlowNode> {
    private RadioButton defaultProcessEvents;
    private FlowNode element;
    private GenerateEventsFeature feature;
    private RadioButton generateEvents;
    private ModificationListener modificationListener;
    private RadioButton noEvents;

    public ActivityGenerateEventsFeatureEditor(UiContainer parent, GenerateEventsFeature feature, boolean hasTitle) {
        super(parent, hasTitle ? feature.getLabel() : null);
        this.feature = feature;
        this.buildUi();
    }

    public ActivityGenerateEventsFeatureEditor(UiContainer parent, FlowNode flowNode, boolean hasTitle) {
        this(parent, (GenerateEventsFeature)flowNode.getFeature(GenerateEventsFeature.class), hasTitle);
        this.element = flowNode;
    }

    @Override
    public void validateEditor() throws ProjectException {
    }

    @Override
    public void applyChanges() {
        ActivityGenerateEvents value = this.getSelectedFeature();
        this.getFeature().setValue((Enum)value);
    }

    @Override
    public void populateValues() {
        this.loadValues();
    }

    @Override
    public void loadValues() {
        switch ((ActivityGenerateEvents)this.getFeature().getValue()) {
            case DO_NOT_GENERATE_EVENTS: {
                this.noEvents.setSelected(true);
                break;
            }
            case GENERATE_EVENTS: {
                this.generateEvents.setSelected(true);
                break;
            }
            case PROCESS_DEFAULT: {
                this.defaultProcessEvents.setSelected(true);
            }
        }
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public FlowNode getElement() {
        return this.element;
    }

    @Override
    public boolean isDirty() {
        return !((ActivityGenerateEvents)this.getFeature().getValue()).equals((Object)this.getSelectedFeature());
    }

    @Override
    public void setElement(FlowNode element) {
        this.element = element;
    }

    private GenerateEventsFeature getFeature() {
        return this.element != null ? (GenerateEventsFeature)this.element.getFeature(GenerateEventsFeature.class) : this.feature;
    }

    private void buildUi() {
        this.setLayout((Layout)new BorderLayout(5, 5));
        Panel radioPanel = new Panel((UiContainer)this);
        radioPanel.setLayout((Layout)new BoxLayout((UiContainer)radioPanel));
        ButtonGroup group = new ButtonGroup();
        this.defaultProcessEvents = new RadioButton((UiContainer)radioPanel, ActivityGenerateEvents.PROCESS_DEFAULT.getMsg());
        this.noEvents = new RadioButton((UiContainer)radioPanel, ActivityGenerateEvents.DO_NOT_GENERATE_EVENTS.getMsg());
        this.generateEvents = new RadioButton((UiContainer)radioPanel, ActivityGenerateEvents.GENERATE_EVENTS.getMsg());
        radioPanel.add((UiComponent)this.defaultProcessEvents);
        radioPanel.add((UiComponent)this.generateEvents);
        radioPanel.add((UiComponent)this.noEvents);
        group.add((AbstractButton)this.defaultProcessEvents);
        group.add((AbstractButton)this.generateEvents);
        group.add((AbstractButton)this.noEvents);
        this.populateValues();
        this.add((UiComponent)radioPanel, "Center");
    }

    private ActivityGenerateEvents getSelectedFeature() {
        ActivityGenerateEvents value = this.noEvents.isSelected() ? ActivityGenerateEvents.DO_NOT_GENERATE_EVENTS : (this.generateEvents.isSelected() ? ActivityGenerateEvents.GENERATE_EVENTS : ActivityGenerateEvents.PROCESS_DEFAULT);
        return value;
    }
}

