/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.flowpanels.ActivityPropertiesPanel;
import oracle.bpm.designer.flowpanels.AdvanceOptionEditor;
import oracle.bpm.designer.flowpanels.BasicEditor;
import oracle.bpm.designer.flowpanels.BasicEventsEditor;
import oracle.bpm.designer.flowpanels.CounterCompositeEditor;
import oracle.bpm.designer.flowpanels.EventPropertiesPanel;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesPreferences;
import oracle.bpm.designer.flowpanels.GatewayPropertiesPanel;
import oracle.bpm.designer.flowpanels.ImageEditor;
import oracle.bpm.designer.flowpanels.LoopCharacteristicsEditor;
import oracle.bpm.designer.flowpanels.OutflowOrderCompositeEditor;
import oracle.bpm.designer.flowpanels.PropertiesSheet;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.command.design.ResetActivityImplementationCommand;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.ActivityPermissionFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.activities.ActivityPermissionType;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

abstract class AbstractFlowNodePropertiesPanel {
    @NotNull
    private final FlowNode flowNode;
    private FlowNodePropertiesPreferences preferences;
    private Sequence<PropertiesSheet> propertiesSheet;
    private ChangeTypeListener rebuidListener;
    private ChangeTypeListener sealTypeChangedListener;
    private TabbedPane tabbedPane;

    protected AbstractFlowNodePropertiesPanel(@NotNull FlowNode flowNode) {
        this.flowNode = flowNode;
    }

    public static AbstractFlowNodePropertiesPanel create(@NotNull FlowNode flowNode, FlowNodePropertiesPreferences preferences) {
        BpmnType bpmnType = flowNode.getBpmnType();
        AbstractFlowNodePropertiesPanel result = bpmnType.isActivity() ? new ActivityPropertiesPanel((Activity)flowNode.asAnyNode(Activity.class)) : (bpmnType.isEvent() ? new EventPropertiesPanel((Event)flowNode.asAnyNode(Event.class)) : (bpmnType.isGateway() ? new GatewayPropertiesPanel((Gateway)flowNode.asAnyNode(Gateway.class)) : new UnknowPropertiesPanel(flowNode)));
        super.setPreferences(preferences);
        return result;
    }

    @NotNull
    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public void validate() throws ProjectException {
        for (PropertiesSheet sheet : this.propertiesSheet) {
            if (!sheet.shouldRender()) continue;
            sheet.validate();
        }
    }

    public void applyChanges() {
        for (PropertiesSheet sheet : this.propertiesSheet) {
            if (!sheet.shouldRender()) continue;
            sheet.applyChanges();
        }
    }

    public UiComponent buildPanel(UiContainer parent) {
        this.tabbedPane = new TabbedPane(parent){

            public String getHelpId() {
                return this.getDefaultHelpId() + "." + AbstractFlowNodePropertiesPanel.this.getFlowNodeHelpId();
            }
        };
        this.createTabs();
        return this.tabbedPane;
    }

    protected abstract String getFlowNodeHelpId();

    protected abstract PropertiesSheet createImplementationSheet(ChangeTypeListener var1);

    protected Sequence<PropertiesSheet> createPropertiesSheet() {
        ArrayList<PropertiesSheet> result = new ArrayList<PropertiesSheet>();
        result.add(this.createBasicSheet());
        result.add(this.createImplementationSheet(this.getRebuildListener()));
        result.add(this.createLoopSheet());
        result.add(this.createCounterSheet());
        result.add(this.createOutflowOrderSheet());
        return CollectionUtils.asSequence(result);
    }

    protected FlowNodePropertiesPreferences getPreferences() {
        return this.preferences;
    }

    ChangeTypeListener getSealTypeChangeListener() {
        if (this.sealTypeChangedListener == null) {
            this.sealTypeChangedListener = new ChangeTypeListener(){

                @Override
                public void changed() {
                    this.checkImplementation();
                    AbstractFlowNodePropertiesPanel.this.rebuild();
                }

                private void checkImplementation() {
                    boolean removeImpl;
                    FlowNode node = AbstractFlowNodePropertiesPanel.this.getFlowNode();
                    ActivityPermissionFeature feature = (ActivityPermissionFeature)node.getFeature(ActivityPermissionFeature.class);
                    ActivityPermissionType type = (ActivityPermissionType)feature.getValue();
                    boolean bl = removeImpl = type == ActivityPermissionType.SHOULD_DEFINE;
                    if (removeImpl) {
                        ResetActivityImplementationCommand.reset((FlowNode)node);
                    }
                }
            };
        }
        return this.sealTypeChangedListener;
    }

    ChangeTypeListener getRebuildListener() {
        if (this.rebuidListener == null) {
            this.rebuidListener = new ChangeTypeListener(){

                @Override
                public void changed() {
                    AbstractFlowNodePropertiesPanel.this.rebuild();
                }
            };
        }
        return this.rebuidListener;
    }

    String getHelpId() {
        return this.tabbedPane.getHelpId();
    }

    private void createTabs() {
        this.propertiesSheet = this.createPropertiesSheet();
        UiComponent selected = null;
        for (PropertiesSheet sheet : this.propertiesSheet) {
            if (!sheet.shouldRender()) continue;
            UiComponent component = sheet.buildEditor((UiContainer)this.tabbedPane);
            this.tabbedPane.addTab(sheet.getTitle(), component);
            if (!this.getPreferences().shouldSelectSheet(sheet)) continue;
            selected = component;
        }
        if (selected != null) {
            this.tabbedPane.setSelectedComponent(selected);
        }
    }

    private PropertiesSheet createBasicSheet() {
        PropertiesSheet result = new PropertiesSheet(UIMsg.BASIC);
        result.setWestEditor(ImageEditor.create(this.getFlowNode()));
        result.addCompositeEditor(BasicEditor.create(this.getFlowNode(), this.getSealTypeChangeListener()));
        result.addCompositeEditor(DesignerMsg.SAMPLING_POINT, BasicEventsEditor.create(this.getFlowNode()));
        result.addCompositeEditor(DesignerMsg.ADVANCED_OPTIONS, AdvanceOptionEditor.create(this.getFlowNode()));
        return result;
    }

    private PropertiesSheet createOutflowOrderSheet() {
        PropertiesSheet result = new PropertiesSheet(DesignerMsg.OUTFLOW_ORDER);
        result.addCompositeEditor(OutflowOrderCompositeEditor.create(this.getFlowNode()));
        return result;
    }

    private PropertiesSheet createCounterSheet() {
        PropertiesSheet result = new PropertiesSheet(DesignerMsg.COUNTER);
        result.addCompositeEditor(CounterCompositeEditor.create(this.getFlowNode()));
        return result;
    }

    private PropertiesSheet createLoopSheet() {
        PropertiesSheet result = new PropertiesSheet(DesignerMsg.LOOP_CHARACTERISTICS){

            @Override
            boolean shouldRender() {
                return super.shouldRender() && !AbstractStudioWorkbench.getInstance().isBusinessAnalyst();
            }
        };
        result.addCompositeEditor(LoopCharacteristicsEditor.create(this.getFlowNode(), this.getRebuildListener()));
        return result;
    }

    private void setPreferences(FlowNodePropertiesPreferences preferences) {
        this.preferences = preferences;
    }

    private void rebuild() {
        if (this.tabbedPane != null) {
            int selection = this.tabbedPane.getSelectedIndex();
            this.tabbedPane.removeAll();
            this.createTabs();
            this.tabbedPane.setSelectedIndex(selection);
            UiContainer parent = this.tabbedPane.getParent();
            parent.revalidate();
            parent.repaint();
        }
    }

    private static class UnknowPropertiesPanel
    extends AbstractFlowNodePropertiesPanel {
        public UnknowPropertiesPanel(@NotNull FlowNode flowNode) {
            super(flowNode);
        }

        @Override
        protected PropertiesSheet createImplementationSheet(ChangeTypeListener changeTypeListener) {
            return new PropertiesSheet(ProjectMsg.IMPLEMENTATION);
        }

        @Override
        protected String getFlowNodeHelpId() {
            return this.getFlowNode().getBpmnType().name();
        }
    }

    static interface ChangeTypeListener {
        public void changed();
    }
}

