/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.List;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;

abstract class AbstractCompositeEditor {
    private List<FlowNodePropertiesEditor> editors;
    private Msg msg;
    private FlowNode node;

    public AbstractCompositeEditor(Msg msg, FlowNode node) {
        this.msg = msg;
        this.node = node;
    }

    public Msg getMsg() {
        return this.msg;
    }

    public final List<FlowNodePropertiesEditor> getEditors() {
        if (this.editors == null) {
            this.editors = this.buildEditors();
        }
        return this.editors;
    }

    public final void clearEditors() {
        this.editors = null;
    }

    public boolean isCollapsed() {
        return true;
    }

    public boolean shouldRender() {
        return !this.getEditors().isEmpty();
    }

    public FlowNode getFlowNode() {
        return this.node;
    }

    public Panel buildEditor(UiContainer parent) {
        Panel panel = new Panel(parent);
        List<FlowNodePropertiesEditor> editors = this.getEditors();
        MigLayout layout = new MigLayout("fillx, gap 5, ins 5");
        panel.setLayout((Layout)layout);
        for (FlowNodePropertiesEditor editor : editors) {
            EditorBuilder editorBuilder = editor.getEditorBuilder();
            editorBuilder.build(panel);
        }
        return panel;
    }

    public final void validate() throws ProjectException {
        if (this.shouldRender()) {
            for (FlowNodePropertiesEditor editor : this.getEditors()) {
                editor.validate();
            }
        }
    }

    public final void applyChanges() {
        if (this.shouldRender()) {
            for (FlowNodePropertiesEditor editor : this.getEditors()) {
                editor.applyChanges();
            }
        }
    }

    protected abstract List<FlowNodePropertiesEditor> buildEditors();
}

