/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;

abstract class AbstractChangeTypeEditor
extends FlowNodePropertiesEditor {
    private ChangeTypeBuilder builder;

    protected AbstractChangeTypeEditor(FlowNode flowNode, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        this.builder = this.createBuilder(flowNode, changeTypeListener);
    }

    @Override
    public void applyChanges() {
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    protected abstract ChangeTypeBuilder createBuilder(FlowNode var1, AbstractFlowNodePropertiesPanel.ChangeTypeListener var2);

    protected static abstract class ChangeTypeBuilder<E>
    extends DefaultEditorBuilder {
        private ArrayList<EditorBuilder.RowBuilder> builders;
        private AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener;
        private FlowNode flowNode;
        private DefaultTheme theme;

        protected ChangeTypeBuilder(FlowNode flowNode, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
            this.flowNode = flowNode;
            this.changeTypeListener = changeTypeListener;
            DefaultRowEditorBuilder editor = new DefaultRowEditorBuilder(DesignerMsg.TASK_TYPE){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    return ChangeTypeBuilder.this.buildCombo(parent);
                }
            };
            this.builders = new ArrayList();
            this.builders.add(editor);
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        protected abstract List<E> getValues();

        protected abstract E getValue();

        protected abstract void applyChange(E var1);

        protected abstract FlowFigureType getFlowFigureType(E var1);

        protected FlowNode getFlowNode() {
            return this.flowNode;
        }

        private ComboBox<E> buildCombo(UiContainer parent) {
            E value = this.getValue();
            List<E> values = this.getValues();
            if (value != null && !values.contains(value)) {
                values.add(0, value);
            }
            final ComboBox typeCombo = UiFactory.createComboBox((UiContainer)parent, values);
            typeCombo.setSelectedItem(value);
            typeCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    final 2 toRemove = this;
                    UiUtilities.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            typeCombo.removeItemListener(toRemove);
                            Object selection = typeCombo.getSelectedItem();
                            ChangeTypeBuilder.this.applyChange(selection);
                            ChangeTypeBuilder.this.changeTypeListener.changed();
                        }
                    });
                }
            });
            typeCombo.setLabelProvider(new LabelProvider<E>(){

                public Image getIcon(E value) {
                    FlowFigureType type = ChangeTypeBuilder.this.getFlowFigureType(value);
                    return type != null ? ChangeTypeBuilder.this.getTheme().getImageFor(type, ImageType.MINI_ICON) : null;
                }

                public String getText(E value) {
                    return value instanceof I18nProvider ? ((I18nProvider)value).getString() : (value == null ? "" : value.toString());
                }
            });
            return typeCombo;
        }

        private DefaultTheme getTheme() {
            if (this.theme == null) {
                this.theme = DesignerPreferences.getPreferences().getTheme();
            }
            return this.theme;
        }
    }

    protected static interface ChangeListener<T> {
        public void changed(T var1);
    }
}

