/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.fixers;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.action.DeleteActionFactory;
import oracle.bpm.designer.action.DeleteObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.extensionpoint.metadata.FixerExtensionPointMetadata;
import oracle.bpm.project.compile.exceptions.MultipleStartNotAllowedException;
import oracle.bpm.project.fixes.Fixer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;

@FixerExtensionPointMetadata(fixableType="oracle.bpm.project.compile.exceptions.MultipleStartNotAllowedException")
public class MultipleStartFixer
implements Fixer<MultipleStartNotAllowedException> {
    public String getDescription() {
        return DesignerMsg.FIX_MULTIPLE_STARTS.getString();
    }

    public void fix(MultipleStartNotAllowedException fixable) {
        NodeContainer container = (NodeContainer)fixable.getProjectObject();
        Sequence starts = ModelUtils.getStartNodes((NodeContainer)container);
        Object[] selectionValues = starts.toArray(new FlowNode[0]);
        Object result = MessageDialog.showOptions((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.REMOVE_STARTS, (Msg)DesignerMsg.CHOOSE_START_TO_KEEP, (Object[])selectionValues, (Object)selectionValues[0]);
        if (result != null) {
            for (Object selectionValue : selectionValues) {
                if (selectionValue == result) continue;
                DeleteObjectAction deleteAction = DeleteActionFactory.getDeleteActionFor((ProjectObject)selectionValue);
                deleteAction.setConfirm(false);
                deleteAction.run();
            }
        }
    }
}

