/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.fixers;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.action.DeleteActionFactory;
import oracle.bpm.designer.action.DeleteObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.extensionpoint.metadata.FixerExtensionPointMetadata;
import oracle.bpm.project.fixes.Fixer;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ActivityException;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;

@FixerExtensionPointMetadata(fixableType="oracle.bpm.project.compile.exceptions.MoreThanOneUnconditionalTransitionException")
public class MoreThanOneOutgoingTransitionFixer
implements Fixer<ActivityException> {
    public String getDescription() {
        return DesignerMsg.FIX_MULTIPLE_OUT_TRANSITIONS.toString();
    }

    public void fix(ActivityException fixable) {
        Sequence options = fixable.getActivity().getOutgoingSequenceFlows();
        SequenceFlow[] sequenceFlows = options.toArray(new SequenceFlow[0]);
        Object[] selectionValues = new String[sequenceFlows.length];
        for (int i = 0; i < sequenceFlows.length; ++i) {
            SequenceFlow sequenceFlow = sequenceFlows[i];
            selectionValues[i] = sequenceFlow.toString();
            if (!((String)selectionValues[i]).trim().equals("")) continue;
            selectionValues[i] = ModelUtils.getBuiltName((SequenceFlow)sequenceFlow);
        }
        Object result = MessageDialog.showOptions((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.REMOVE_TRANSITIONS, (Msg)DesignerMsg.CHOOSE_TRANSITION_TO_KEEP, (Object[])selectionValues, (Object)selectionValues[0]);
        if (result != null) {
            for (int i = 0; i < selectionValues.length; ++i) {
                if (selectionValues[i] == result) continue;
                DeleteObjectAction deleteAction = DeleteActionFactory.getDeleteActionFor((ProjectObject)sequenceFlows[i]);
                deleteAction.setConfirm(false);
                deleteAction.run();
            }
        }
    }
}

