/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression.selector;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.expression.selector.ExpressionModeSelector;
import oracle.bpm.designer.expression.selector.ExpressionModeSelectorImpl;
import oracle.bpm.designer.expression.selector.ExpressionModeSelectorItem;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class ExpressionModeSelectorRadio
extends ExpressionModeSelectorImpl
implements ExpressionModeSelector {
    private Map<ExpressionMode, RadioButton<ExpressionMode>> modeSelectionButtons;
    private ButtonGroup<RadioButton<ExpressionMode>> modeSelectionGroup;
    private Panel modeSelectorPanel;

    public ExpressionModeSelectorRadio(@NotNull UiContainer container, @NotNull Sequence<ExpressionModeSelectorItem> items) {
        this.init(container, items);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (RadioButton<ExpressionMode> button : this.modeSelectionButtons.values()) {
            button.setEnabled(enabled);
        }
    }

    @Override
    public UiComponent getUiComponent() {
        return this.modeSelectorPanel;
    }

    @Override
    public void setExpressionMode(ExpressionMode mode) {
        RadioButton<ExpressionMode> radio = this.modeSelectionButtons.get(mode);
        if (radio != null) {
            this.modeSelectionGroup.setSelected(radio, true);
        }
    }

    @Override
    public ExpressionMode getExpressionMode() {
        ExpressionMode result = null;
        RadioButton selection = (RadioButton)this.modeSelectionGroup.getSelection();
        if (selection != null) {
            result = (ExpressionMode)selection.getItem();
        }
        return result;
    }

    private void init(@NotNull UiContainer container, @NotNull Sequence<ExpressionModeSelectorItem> items) {
        this.modeSelectorPanel = new Panel(container);
        this.modeSelectorPanel.setLayout((Layout)new MigLayout("ins 0, gap 0"));
        this.modeSelectionGroup = new ButtonGroup();
        this.modeSelectionButtons = new HashMap<ExpressionMode, RadioButton<ExpressionMode>>();
        for (ExpressionModeSelectorItem item : items) {
            this.addRadio((UiContainer)this.modeSelectorPanel, item);
        }
    }

    private void addRadio(@NotNull UiContainer container, @NotNull ExpressionModeSelectorItem item) {
        final RadioButton modeRadioButton = new RadioButton(container, item.getLabel());
        ExpressionMode mode = item.getExpressionMode();
        modeRadioButton.setItem((Object)mode);
        this.modeSelectionButtons.put(mode, (RadioButton<ExpressionMode>)modeRadioButton);
        this.modeSelectionGroup.add((AbstractButton)modeRadioButton);
        container.add((UiComponent)modeRadioButton, (Object)"gapright 5");
        modeRadioButton.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                if (modeRadioButton.isSelected()) {
                    ExpressionModeSelectorRadio.this.setExpressionMode((ExpressionMode)modeRadioButton.getItem());
                    ExpressionModeSelectorRadio.this.fireModeChanged();
                }
            }
        });
    }
}

