/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression.selector;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.expression.selector.ExpressionModeSelector;
import oracle.bpm.designer.expression.selector.ExpressionModeSelectorImpl;
import oracle.bpm.designer.expression.selector.ExpressionModeSelectorItem;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class ExpressionModeSelectorCombo
extends ExpressionModeSelectorImpl
implements ExpressionModeSelector {
    private ComboBox<ExpressionModeSelectorItem> comboSelector;
    private Panel panel;

    public ExpressionModeSelectorCombo(@NotNull UiContainer container, @NotNull Sequence<ExpressionModeSelectorItem> items, boolean showLabel) {
        this.init(container, items, showLabel);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.comboSelector.setEnabled(enabled);
    }

    @Override
    public UiComponent getUiComponent() {
        return this.panel;
    }

    @Override
    public void setExpressionMode(ExpressionMode mode) {
        ExpressionModeSelectorItem itemToSelect = null;
        for (int i = 0; i < this.comboSelector.getItemCount(); ++i) {
            ExpressionModeSelectorItem item = (ExpressionModeSelectorItem)this.comboSelector.getItemAt(i);
            if (item.getExpressionMode() != mode) continue;
            itemToSelect = item;
        }
        this.comboSelector.setSelectedItem(itemToSelect);
    }

    @Override
    public ExpressionMode getExpressionMode() {
        ExpressionModeSelectorItem selectorItem = (ExpressionModeSelectorItem)this.comboSelector.getSelectedItem();
        return selectorItem != null ? selectorItem.getExpressionMode() : null;
    }

    private void init(@NotNull UiContainer container, @NotNull Sequence<ExpressionModeSelectorItem> items, boolean showLabel) {
        this.panel = new Panel(container);
        this.panel.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
        if (showLabel) {
            this.panel.add((UiComponent)Label.create((UiContainer)this.panel, (Msg)DesignerMsg.MODE), (Object)"gapright 5");
        }
        this.comboSelector = UiFactory.createComboBox((UiContainer)this.panel);
        for (ExpressionModeSelectorItem mode : items) {
            this.comboSelector.addItem((Object)mode);
        }
        this.comboSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    ExpressionModeSelectorCombo.this.fireModeChanged();
                }
            }
        });
        this.comboSelector.setLabelProvider((LabelProvider)new LabelProvider<ExpressionModeSelectorItem>(){

            public Image getIcon(ExpressionModeSelectorItem element) {
                return element.getIcon();
            }

            public String getText(ExpressionModeSelectorItem element) {
                return element.getLabel();
            }
        });
        this.panel.add(this.comboSelector, (Object)"growx");
    }
}

