/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression.editorfactory;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ExpressionBuilderService;
import oracle.bpm.designer.expression.ExpressionContainer;
import oracle.bpm.designer.expression.ExpressionEditorType;
import oracle.bpm.designer.expression.editor.TextEditableLOVExpressionField;
import oracle.bpm.designer.expression.editorfactory.ExpressionEditorFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class TextEditableLOVExpressionEditorFactory
implements ExpressionEditorFactory {
    private Sequence<String> values;

    public TextEditableLOVExpressionEditorFactory(@NotNull Sequence<String> values) {
        this.values = values;
    }

    @Override
    public ExpressionContainer createExpressionEditor(@NotNull ExpressionEditorType type, @NotNull UiContainer parent, @NotNull ExpressionContext context, Expression expression) {
        ExpressionBuilderService service;
        ExpressionContainer result = null;
        if (type == ExpressionEditorType.SINGLE_LINE || type == ExpressionEditorType.MULTI_LINE) {
            result = new TextEditableLOVExpressionField(parent, context, this.values);
        } else if (type == ExpressionEditorType.EXPRESSION_BUILDER && (service = AbstractStudioWorkbench.getInstance().getExpressionBuilderService()) != null) {
            result = service.createExpressionBuilder(parent, this.getExpressionMode(), context, expression);
        }
        return result;
    }

    @Override
    @NotNull
    public ExpressionMode getExpressionMode() {
        return ExpressionMode.TEXT;
    }

    @Override
    @NotNull
    public Image getSelectorIcon() {
        return Image.create((Msg)DesignerMsg.ENUM);
    }

    @Override
    @NotNull
    public String getSelectorLabel() {
        return DesignerMsg.LITERAL.getString();
    }

    @Override
    public boolean isExpressionBuilderAvailable() {
        return true;
    }
}

