/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression.editorfactory;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ExpressionBuilderService;
import oracle.bpm.designer.expression.ExpressionContainer;
import oracle.bpm.designer.expression.ExpressionEditorType;
import oracle.bpm.designer.expression.editor.TextExpressionField;
import oracle.bpm.designer.expression.editorfactory.ExpressionEditorFactory;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class PlainTextExpressionEditorFactory
implements ExpressionEditorFactory {
    @Override
    public ExpressionContainer createExpressionEditor(@NotNull ExpressionEditorType type, @NotNull UiContainer parent, @NotNull ExpressionContext context, Expression expression) {
        ExpressionBuilderService service;
        ExpressionContainer result = null;
        if (type == ExpressionEditorType.SINGLE_LINE) {
            result = new TextExpressionField(parent, context, false);
        } else if (type == ExpressionEditorType.MULTI_LINE) {
            result = new TextExpressionField(parent, context, true);
        } else if (type == ExpressionEditorType.EXPRESSION_BUILDER && (service = AbstractStudioWorkbench.getInstance().getExpressionBuilderService()) != null) {
            result = service.createExpressionBuilder(parent, this.getExpressionMode(), context, expression);
        }
        return result;
    }

    @Override
    @NotNull
    public ExpressionMode getExpressionMode() {
        return ExpressionMode.TEXT;
    }

    @Override
    @NotNull
    public Image getSelectorIcon() {
        return Image.create((Msg)LibMsg.TEXT);
    }

    @Override
    @NotNull
    public String getSelectorLabel() {
        return LibMsg.TEXT.getString();
    }

    @Override
    public boolean isExpressionBuilderAvailable() {
        return true;
    }
}

