/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression.editorfactory;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.expression.ExpressionContainer;
import oracle.bpm.designer.expression.ExpressionEditorType;
import oracle.bpm.designer.expression.editor.NumericLOVExpressionField;
import oracle.bpm.designer.expression.editorfactory.ExpressionEditorFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class NumericLOVExpressionEditorFactory
implements ExpressionEditorFactory {
    private LabelProvider<Integer> labelProvider;
    private Sequence<Integer> values;

    public NumericLOVExpressionEditorFactory(@NotNull Sequence<Integer> values, @NotNull LabelProvider<Integer> labelProvider) {
        this.values = values;
        this.labelProvider = labelProvider;
    }

    @Override
    public ExpressionContainer createExpressionEditor(@NotNull ExpressionEditorType type, @NotNull UiContainer parent, @NotNull ExpressionContext context, Expression expression) {
        NumericLOVExpressionField result = null;
        if (type == ExpressionEditorType.SINGLE_LINE || type == ExpressionEditorType.MULTI_LINE) {
            result = new NumericLOVExpressionField(parent, context, this.values, this.labelProvider);
        } else if (type == ExpressionEditorType.EXPRESSION_BUILDER) {
            // empty if block
        }
        return result;
    }

    @Override
    @NotNull
    public ExpressionMode getExpressionMode() {
        return ExpressionMode.NUMBER;
    }

    @Override
    @NotNull
    public Image getSelectorIcon() {
        return Image.create((Msg)DesignerMsg.ENUM);
    }

    @Override
    @NotNull
    public String getSelectorLabel() {
        return DesignerMsg.LITERAL.getString();
    }

    @Override
    public boolean isExpressionBuilderAvailable() {
        return false;
    }
}

