/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression.editor;

import oracle.bpm.designer.expression.ExpressionContainerImpl;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class TextExpressionField
extends ExpressionContainerImpl {
    private TextComponent textField;

    public TextExpressionField(@NotNull UiContainer parent, @NotNull ExpressionContext context, boolean multiLine) {
        super(parent, context);
        this.init(multiLine);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    @Override
    public void setExpression(Expression expression) {
        assert (expression == null || expression instanceof InvalidExpression || expression.getMode().equals(ExpressionMode.TEXT)) : "Invalid expression mode for Text field";
        if (Any.equals(this.getExpression(), expression)) {
            return;
        }
        this.setTextFromExpression(expression);
        this.fireExpressionChanged();
    }

    @Override
    public Expression getExpression() {
        return this.createExpressionFromText();
    }

    @Override
    public boolean isExpressionValid() {
        return true;
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    private void init(boolean multiLine) {
        String layoutConstraints = "hidemode 3, ins 0, gap 0, " + (multiLine ? "fill" : "fillx");
        this.setLayout((Layout)new MigLayout(layoutConstraints));
        this.setBackground(this.getParent().getBackground());
        this.textField = this.createLiteralTextField((UiContainer)this, multiLine);
        String textFieldConstraints = multiLine ? "grow" : "growx";
        this.add((UiComponent)this.textField, textFieldConstraints);
        this.revalidateExpression();
    }

    private Expression createExpressionFromText() {
        Expression result = null;
        if (!Str.isEmpty(this.textField.getText())) {
            result = ExpressionHelper.createTextExpression((String)this.textField.getText());
        }
        return result;
    }

    private TextComponent createLiteralTextField(@NotNull UiContainer container, boolean multiLine) {
        TextArea result = multiLine ? new TextArea(container) : new TextField(container);
        result.addDocumentListener((DocumentListener)new DocumentListener.Default(){

            public void anyUpdate(DocumentEvent e) {
                TextExpressionField.this.fireExpressionChanged();
            }
        });
        return result;
    }

    private void setTextFromExpression(Expression expression) {
        String text = expression != null ? ExpressionHelper.getText((Expression)expression, (ExpressionContext)this.getContext()) : "";
        this.textField.setText(text);
        this.textField.setCaretPosition(0);
    }
}

