/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression.editor;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.expression.ExpressionContainerImpl;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ModifyEvent;
import oracle.bpm.ui.event.ModifyListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class TextEditableLOVExpressionField
extends ExpressionContainerImpl {
    private ComboBox<String> comboBox;

    public TextEditableLOVExpressionField(@NotNull UiContainer parent, @NotNull ExpressionContext context, @NotNull Sequence<String> values) {
        super(parent, context);
        this.init(values);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.comboBox.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox.isEnabled();
    }

    @Override
    public void setExpression(Expression expression) {
        assert (expression == null || expression instanceof InvalidExpression || expression.getMode().equals(ExpressionMode.TEXT)) : "Invalid expression mode for text combobox";
        if (Any.equals(this.getExpression(), expression)) {
            return;
        }
        this.setTextFromExpression(expression);
        this.fireExpressionChanged();
    }

    @Override
    public Expression getExpression() {
        return this.createExpressionFromText();
    }

    @Override
    public boolean isExpressionValid() {
        return true;
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    private void init(@NotNull Sequence<String> values) {
        this.setLayout((Layout)new MigLayout("hidemode 3, ins 0, gap 0, fillx"));
        this.setBackground(this.getParent().getBackground());
        this.comboBox = this.createLiteralTextComboBox((UiContainer)this, values);
        this.add((UiComponent)this.comboBox, "growx");
        this.revalidateExpression();
    }

    private Expression createExpressionFromText() {
        Expression result = null;
        if (!Str.isEmpty(this.comboBox.getText())) {
            result = ExpressionHelper.createTextExpression((String)this.comboBox.getText());
        }
        return result;
    }

    private ComboBox<String> createLiteralTextComboBox(@NotNull UiContainer container, @NotNull Sequence<String> values) {
        ComboBox result = UiFactory.createComboBox((UiContainer)container, (boolean)true);
        result.addItems(values);
        result.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextEditableLOVExpressionField.this.fireExpressionChanged();
            }
        });
        return result;
    }

    private void setTextFromExpression(Expression expression) {
        String text = expression != null ? ExpressionHelper.getText((Expression)expression, (ExpressionContext)this.getContext()) : "";
        this.comboBox.setText(text);
    }
}

