/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression.editor;

import java.util.Iterator;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.CodeEditorService;
import oracle.bpm.designer.expression.ExpressionContainerImpl;
import oracle.bpm.editor.CodeEditor;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DropTargetHandler;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class SimpleExpressionEditorField
extends ExpressionContainerImpl {
    private CodeEditor codeEditor;

    public SimpleExpressionEditorField(@NotNull UiContainer parent, @NotNull ExpressionContext context, boolean multiLine) {
        super(parent, context);
        this.init(multiLine);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getEditorView().setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.getEditorView().isEnabled();
    }

    @Override
    public void setExpression(Expression expression) {
        assert (expression == null || expression instanceof InvalidExpression || expression.getMode().equals(ExpressionMode.SIMPLE)) : "Invalid expression mode for Simple field";
        if (Any.equals(this.getExpression(), expression)) {
            return;
        }
        this.setTextFromExpression(expression);
        this.fireExpressionChanged();
    }

    @Override
    public void revalidateExpression() {
        this.codeEditor.touch();
    }

    @Override
    public void setContext(@NotNull ExpressionContext context) {
        super.setContext(context);
        this.updateCodeEditorContext();
    }

    @Override
    public Expression getExpression() {
        return this.createExpressionFromText();
    }

    @Override
    public boolean isExpressionValid() {
        Expression expression = this.getExpression();
        return expression == null || ExpressionHelper.isExpressionValid((Expression)expression, (ExpressionContext)this.getContext());
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    private void updateCodeEditorContext() {
        CodeEditorService service = AbstractStudioWorkbench.getInstance().getCodeEditorService();
        service.setEditorContext(this.codeEditor, this.getContext());
    }

    private void init(boolean multiLine) {
        this.setLayout((Layout)new MigLayout("hidemode 3, ins 0, gap 0, fill"));
        this.setBackground(this.getParent().getBackground());
        this.initCodeEditor(multiLine);
        this.add(this.getEditorView(), "grow");
    }

    private void initCodeEditor(boolean multiLine) {
        CodeEditorService service = AbstractStudioWorkbench.getInstance().getCodeEditorService();
        this.codeEditor = service.getFusionCodeEditor(this.getContext(), multiLine);
        this.codeEditor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SimpleExpressionEditorField.this.fireExpressionChanged();
            }
        });
        UiComponent droppableComponent = this.codeEditor.getDroppableComponent();
        new DropTargetHandler(droppableComponent, DndAction.COPY_OR_MOVE){

            public void drop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                if (transfer == LocalObjectTransfer.getInstance(Sequence.class)) {
                    Sequence dataDeclarationsPath = (Sequence)Cast.force(data);
                    Expression expression = ExpressionHelper.createExpressionFromParts((ExpressionMode)ExpressionMode.SIMPLE, (Sequence)dataDeclarationsPath, (ExpressionContext)SimpleExpressionEditorField.this.getContext());
                    SimpleExpressionEditorField.this.setExpression(expression);
                }
            }

            public Transfer[] getTransfers() {
                return new Transfer[]{LocalObjectTransfer.getInstance(Sequence.class)};
            }

            public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                if (SimpleExpressionEditorField.this.codeEditor.isEnabled() && transfer.equals(LocalObjectTransfer.getInstance(Sequence.class))) {
                    Sequence dataDeclarationsPath = (Sequence)Cast.force(data);
                    CatalogType leafType = this.getLeaf(dataDeclarationsPath).getType();
                    boolean isLeafReadOnly = this.getLeaf(dataDeclarationsPath).isReadOnly();
                    CatalogType resultType = SimpleExpressionEditorField.this.getContext().getResultType();
                    boolean isLValue = SimpleExpressionEditorField.this.getContext().isLValue();
                    return !(resultType != null && !resultType.isAssignableFrom(leafType) || isLValue && isLeafReadOnly);
                }
                return false;
            }

            private DataDeclaration getLeaf(Sequence<DataDeclaration> dataDeclarationsPath) {
                DataDeclaration result = null;
                Iterator<DataDeclaration> i$ = dataDeclarationsPath.iterator();
                while (i$.hasNext()) {
                    DataDeclaration part;
                    result = part = i$.next();
                }
                return result;
            }
        };
    }

    private Expression createExpressionFromText() {
        Expression result = null;
        if (!Str.isEmpty(this.codeEditor.getText())) {
            result = ExpressionHelper.createSimpleExpression((String)this.codeEditor.getText(), (ExpressionContext)this.getContext());
        }
        return result;
    }

    private UiComponent getEditorView() {
        return this.codeEditor.getView();
    }

    private void setTextFromExpression(Expression expression) {
        String text = expression != null ? ExpressionHelper.getText((Expression)expression, (ExpressionContext)this.getContext()) : "";
        this.codeEditor.setText(text);
        this.codeEditor.setCaretPosition(0);
    }
}

