/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression.editor;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.expression.ExpressionContainerImpl;
import oracle.bpm.lang.Any;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class NumericLOVExpressionField
extends ExpressionContainerImpl {
    private ComboBox<Integer> comboBox;

    public NumericLOVExpressionField(@NotNull UiContainer parent, @NotNull ExpressionContext context, @NotNull Sequence<Integer> values, @NotNull LabelProvider<Integer> labelProvider) {
        super(parent, context);
        this.init(values, labelProvider);
    }

    @Override
    public void setExpression(Expression expression) {
        assert (expression == null || expression instanceof InvalidExpression || expression.getMode().equals(ExpressionMode.NUMBER)) : "Invalid expression mode for Numeric List of Values field";
        if (Any.equals(this.getExpression(), expression)) {
            return;
        }
        Integer newValue = this.getValueFromExpression(expression);
        if (newValue == null) {
            this.comboBox.setSelectedIndex(-1);
        } else if (this.comboBox.containsItem((Object)newValue)) {
            this.comboBox.setSelectedItem((Object)newValue);
        }
        this.fireExpressionChanged();
    }

    @Override
    public Expression getExpression() {
        return this.createExpressionFromSelectedItem();
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    private void init(@NotNull Sequence<Integer> values, @NotNull LabelProvider<Integer> labelProvider) {
        this.setLayout((Layout)new MigLayout("hidemode 3, ins 0, gap 0, fillx"));
        this.setBackground(this.getParent().getBackground());
        this.comboBox = UiFactory.createComboBox((UiContainer)this);
        this.add((UiComponent)this.comboBox, "growx");
        this.comboBox.setLabelProvider(labelProvider);
        for (Integer value : values) {
            this.comboBox.addItem((Object)value);
        }
        this.comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    NumericLOVExpressionField.this.fireExpressionChanged();
                }
            }
        });
        Button clearButton = Button.createIconic((UiContainer)this, (Msg)UIMsg.CLEAR);
        this.add((UiComponent)clearButton, "gapx 5");
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NumericLOVExpressionField.this.setExpression(null);
            }
        });
    }

    private Expression createExpressionFromSelectedItem() {
        Expression result = null;
        Integer selectedItem = (Integer)this.comboBox.getSelectedItem();
        if (selectedItem != null) {
            result = ExpressionHelper.createNumericExpression((Integer)selectedItem);
        }
        return result;
    }

    private Integer getValueFromExpression(Expression expression) {
        return expression != null ? ExpressionHelper.getNumberFromNumericExpression((Expression)expression) : null;
    }
}

