/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression.editor;

import oracle.bpm.designer.expression.ExpressionContainerImpl;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Cast;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DropTargetHandler;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class DefaultExpressionField
extends ExpressionContainerImpl {
    private Expression expression;
    private ExpressionMode mode;
    private TextComponent textField;

    public DefaultExpressionField(@NotNull UiContainer parent, @NotNull ExpressionMode mode, @NotNull ExpressionContext context, boolean multiLine) {
        super(parent, context);
        this.mode = mode;
        this.init(multiLine);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    @Override
    public void setExpression(Expression expression) {
        assert (expression == null || expression instanceof InvalidExpression || expression.getMode().equals(this.mode)) : "Invalid expression mode for Default Expression Field (Expected: " + this.mode.getString() + ")";
        if (Any.equals(this.expression, expression)) {
            return;
        }
        this.expression = expression;
        this.setText();
        this.fireExpressionChanged();
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public boolean isExpressionValid() {
        return true;
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    private void init(boolean multiLine) {
        String layoutConstraints = "hidemode 3, ins 0, gap 0, " + (multiLine ? "fill" : "fillx");
        this.setLayout((Layout)new MigLayout(layoutConstraints));
        this.setBackground(this.getParent().getBackground());
        this.textField = this.createTextField((UiContainer)this, multiLine);
        String textFieldConstraints = multiLine ? "grow" : "growx";
        this.add((UiComponent)this.textField, textFieldConstraints);
    }

    private TextComponent createTextField(@NotNull UiContainer container, boolean multiLine) {
        TextArea newtextField = multiLine ? new TextArea(container) : new TextField(container);
        newtextField.setEditable(false);
        new DropTargetHandler((UiComponent)newtextField, DndAction.COPY_OR_MOVE){

            public void drop(Object data, Transfer type, Point point, DndAction dndAction) {
                if (type == LocalObjectTransfer.getInstance(Expression.class)) {
                    Expression expression = (Expression)Cast.force(data);
                    DefaultExpressionField.this.setExpression(expression);
                }
            }

            public Transfer[] getTransfers() {
                return new Transfer[]{LocalObjectTransfer.getInstance(Expression.class)};
            }

            public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                Expression expression;
                boolean result = false;
                if (transfer == LocalObjectTransfer.getInstance(Expression.class) && (expression = (Expression)Cast.force(data)).getMode() == DefaultExpressionField.this.mode) {
                    result = true;
                }
                return result;
            }
        };
        return newtextField;
    }

    private void setText() {
        String text = this.expression != null ? ExpressionHelper.getText((Expression)this.expression, (ExpressionContext)this.getContext()) : "";
        this.textField.setText(text);
        this.textField.setCaretPosition(0);
        Msg tooltip = this.expression != null ? Msg.QUOTE(text) : null;
        this.textField.setToolTipText(tooltip);
    }
}

