/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.expression.ExpressionBuilderDialog;
import oracle.bpm.designer.expression.ExpressionContainer;
import oracle.bpm.designer.expression.ExpressionContainerImpl;
import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.designer.expression.ExpressionEditorType;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.editorfactory.ExpressionEditorFactory;
import oracle.bpm.designer.expression.selector.ExpressionModeSelector;
import oracle.bpm.designer.expression.selector.ExpressionModeSelectorItem;
import oracle.bpm.designer.expression.selector.ExpressionModeSelectorListener;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Any;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ExpressionPanelImpl
extends ExpressionContainerImpl
implements ExpressionPanel {
    private ExpressionContainer delegate;
    private Button expressionBuilderIcon;
    private ExpressionMode expressionMode;
    private Sequence<ExpressionEditorFactory> factories;
    private Panel placeHolder;
    private ExpressionModeSelector selector;

    protected ExpressionPanelImpl(@NotNull UiContainer parent, @NotNull Sequence<ExpressionEditorFactory> factories, @NotNull ExpressionContext context, boolean displaySelector) {
        super(parent, context);
        this.factories = factories;
        this.init(displaySelector);
    }

    @Override
    public ExpressionMode getExpressionMode() {
        return this.expressionMode;
    }

    @Override
    public void setExpressionMode(@NotNull ExpressionMode mode) {
        this.changeMode(mode, this.getExpression(), true);
    }

    @Override
    public void setExpression(Expression expression) {
        Expression newExpression = expression;
        if (newExpression != null && !ExpressionHelper.isExpressionValid((Expression)newExpression, (ExpressionContext)this.getContext())) {
            newExpression = this.convertExpression(newExpression, ExpressionMode.XPATH);
        }
        if (Any.equals(this.getExpression(), newExpression)) {
            return;
        }
        if (newExpression != null && !newExpression.getMode().equals(this.getExpressionMode())) {
            this.changeMode(newExpression.getMode(), newExpression, false);
        } else if (this.delegate.rebuildWhenExpressionChanges()) {
            this.rebuildDelegate(this.getExpressionMode(), newExpression);
        }
        this.delegate.setExpression(newExpression);
    }

    @Override
    public Expression getExpression() {
        Expression result = null;
        if (this.delegate != null) {
            result = this.delegate.getExpression();
        }
        return result;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.selector.setEnabled(enabled);
        this.delegate.setEnabled(enabled);
        if (this.expressionBuilderIcon != null) {
            this.expressionBuilderIcon.setEnabled(enabled);
        }
    }

    @Override
    public void addListener(ExpressionContainerListener listener) {
        super.addListener(listener);
        this.delegate.addListener(listener);
    }

    @Override
    public void removeListener(ExpressionContainerListener listener) {
        super.addListener(listener);
        this.delegate.removeListener(listener);
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    @Override
    public boolean isExpressionValid() {
        return this.delegate.isExpressionValid();
    }

    @Override
    public void revalidateExpression() {
        this.delegate.revalidateExpression();
    }

    @Override
    public void setContext(@NotNull ExpressionContext context) {
        super.setContext(context);
        this.delegate.setContext(context);
    }

    protected abstract void layoutControls(@NotNull UiContainer var1, @NotNull UiComponent var2, @NotNull UiComponent var3, @NotNull UiComponent var4, boolean var5);

    protected abstract ExpressionModeSelector createSelector(@NotNull UiContainer var1, @NotNull Sequence<ExpressionModeSelectorItem> var2);

    protected abstract ExpressionEditorType getExpressionEditorType();

    protected void changeMode(ExpressionMode newExpressionMode, Expression oldExpression, boolean mustConvertExpression) {
        if (Any.equals(newExpressionMode, this.expressionMode)) {
            return;
        }
        Expression newExpression = oldExpression;
        if (mustConvertExpression) {
            int answer;
            newExpression = this.convertExpression(oldExpression, newExpressionMode);
            if (this.getExpression() != null && newExpression == null && (answer = MessageDialog.showQuestion((Msg)DesignerMsg.EXPRESSION, (Msg)DesignerMsg.CONFIRM_EXPRESSION_CONVERSION, (int)6)) == 4) {
                this.selector.setExpressionMode(this.expressionMode);
                return;
            }
        }
        this.expressionMode = newExpressionMode;
        this.selector.setExpressionMode(newExpressionMode);
        this.rebuildDelegate(newExpressionMode, newExpression);
        this.setExpression(newExpression);
    }

    protected boolean mustDisplayNonExpressionBuilders() {
        return true;
    }

    protected void rebuildDelegate(@NotNull ExpressionMode newExpressionMode, @Nullable Expression newExpression) {
        if (this.delegate != null) {
            this.placeHolder.remove(this.delegate.getUiComponent());
        }
        ExpressionEditorFactory factory = this.getFactory(newExpressionMode);
        this.delegate = factory.createExpressionEditor(this.getExpressionEditorType(), (UiContainer)this.placeHolder, this.getContext(), newExpression);
        this.placeHolder.add(this.delegate.getUiComponent(), (Object)"Center");
        for (ExpressionContainerListener listener : this.listeners) {
            this.delegate.addListener(listener);
        }
        this.expressionBuilderIcon.setVisible(factory.isExpressionBuilderAvailable());
        this.revalidate();
    }

    private Sequence<ExpressionModeSelectorItem> getSelectorItems() {
        ArrayList<ExpressionModeSelectorItem> result = new ArrayList<ExpressionModeSelectorItem>();
        for (ExpressionEditorFactory factory : this.factories) {
            if (!this.mustDisplayNonExpressionBuilders() && !factory.isExpressionBuilderAvailable()) continue;
            ExpressionModeSelectorItem item = new ExpressionModeSelectorItem(factory.getExpressionMode(), factory.getSelectorIcon(), factory.getSelectorLabel());
            result.add(item);
        }
        return CollectionUtils.asSequence(result);
    }

    private Expression convertExpression(Expression oldExpression, ExpressionMode newExpressionMode) {
        Expression result = null;
        if (oldExpression != null && !(oldExpression instanceof InvalidExpression) && (result = ExpressionHelper.convertExpression((XPathExpression)((XPathExpression)oldExpression), (ExpressionContext)this.getContext(), (ExpressionMode)newExpressionMode)) != null && result instanceof InvalidExpression) {
            result = null;
        }
        return result;
    }

    private void init(boolean displaySelector) {
        this.setLayout((Layout)new MigLayout("hidemode 3, ins 0, gap 0, fill"));
        this.setBackground(this.getParent().getBackground());
        this.selector = this.createSelector((UiContainer)this, this.getSelectorItems());
        this.selector.addListener(new ExpressionModeSelectorListener(){

            @Override
            public void modeChanged() {
                ExpressionPanelImpl.this.setExpressionMode(ExpressionPanelImpl.this.selector.getExpressionMode());
            }
        });
        this.placeHolder = new Panel((UiContainer)this);
        this.placeHolder.setLayout((Layout)new BorderLayout());
        this.expressionBuilderIcon = this.createExpressionBuilderButton((UiContainer)this);
        if (!this.getSelectorItems().isEmpty()) {
            ExpressionMode expressionMode = this.getSelectorItems().iterator().next().getExpressionMode();
            this.setExpressionMode(expressionMode);
        }
        this.layoutControls((UiContainer)this, this.selector.getUiComponent(), (UiComponent)this.placeHolder, (UiComponent)this.expressionBuilderIcon, displaySelector);
    }

    private Button createExpressionBuilderButton(final @NotNull UiContainer container) {
        Button button = Button.createIconic((UiContainer)container, (Msg)DesignerMsg.EXPRESSION_BUILDER);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpressionBuilderDialog expressionBuilder = ExpressionBuilderDialog.create(container.getOwnerWindow(), ExpressionPanelImpl.this.factories, ExpressionPanelImpl.this.expressionMode, ExpressionPanelImpl.this.getContext(), ExpressionPanelImpl.this.getExpression());
                expressionBuilder.setValidateExpression(true);
                if (expressionBuilder.showDialog()) {
                    ExpressionPanelImpl.this.setExpression(expressionBuilder.getExpression());
                }
            }
        });
        return button;
    }

    private ExpressionEditorFactory getFactory(@NotNull ExpressionMode mode) {
        for (ExpressionEditorFactory factory : this.factories) {
            if (!factory.getExpressionMode().equals(mode)) continue;
            return factory;
        }
        return null;
    }
}

