/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.HumanTaskService;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.MultiLineExpressionPanel;
import oracle.bpm.designer.expression.SingleLineExpressionPanel;
import oracle.bpm.designer.expression.editorfactory.ExpressionEditorFactory;
import oracle.bpm.designer.expression.editorfactory.NumericLOVExpressionEditorFactory;
import oracle.bpm.designer.expression.editorfactory.PlainTextExpressionEditorFactory;
import oracle.bpm.designer.expression.editorfactory.SimpleExpressionEditorFactory;
import oracle.bpm.designer.expression.editorfactory.TextEditableLOVExpressionEditorFactory;
import oracle.bpm.designer.expression.editorfactory.XPathExpressionEditorFactory;
import oracle.bpm.designer.expression.editorfactory.XmlLiteralExpressionEditorFactory;
import oracle.bpm.designer.flowpanels.PriorityCombo;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class ExpressionPanelFactory {
    public static ExpressionPanel createDefaultMultiLinePanel(@NotNull UiContainer parent, @NotNull ExpressionContext context) {
        ArrayList<ExpressionEditorFactory> factories = new ArrayList<ExpressionEditorFactory>();
        CatalogType resultType = context.getResultType();
        if (resultType != null && CatalogType.Default.getString().equals(resultType) && !context.isLValue()) {
            factories.add(new PlainTextExpressionEditorFactory());
        }
        factories.add(new SimpleExpressionEditorFactory());
        factories.add(new XPathExpressionEditorFactory());
        Sequence<ExpressionEditorFactory> factoriesSequence = CollectionUtils.asSequence(factories);
        return MultiLineExpressionPanel.create(parent, factoriesSequence, context, true);
    }

    public static ExpressionPanel createDataAssociationPanel(@NotNull UiContainer parent, @NotNull ExpressionContext context) {
        ArrayList<ExpressionEditorFactory> factories = new ArrayList<ExpressionEditorFactory>();
        boolean isLValue = context.isLValue();
        factories.add(new SimpleExpressionEditorFactory());
        factories.add(new XPathExpressionEditorFactory());
        if (!isLValue) {
            factories.add(new XmlLiteralExpressionEditorFactory());
        }
        Sequence<ExpressionEditorFactory> factoriesSequence = CollectionUtils.asSequence(factories);
        return SingleLineExpressionPanel.create(parent, factoriesSequence, context, false);
    }

    public static ExpressionPanel createCorrelationPropertyAliasPanel(@NotNull UiContainer parent, @NotNull ExpressionContext context, boolean multiLine) {
        ArrayList<ExpressionEditorFactory> factories = new ArrayList<ExpressionEditorFactory>();
        factories.add(new SimpleExpressionEditorFactory());
        factories.add(new XPathExpressionEditorFactory());
        Sequence<ExpressionEditorFactory> factoriesSequence = CollectionUtils.asSequence(factories);
        return multiLine ? MultiLineExpressionPanel.create(parent, factoriesSequence, context, false) : SingleLineExpressionPanel.create(parent, factoriesSequence, context, false);
    }

    public static ExpressionPanel createDefaultSingleLinePanel(@NotNull UiContainer parent, @NotNull ExpressionContext context) {
        ArrayList<ExpressionEditorFactory> factories = new ArrayList<ExpressionEditorFactory>();
        CatalogType resultType = context.getResultType();
        if (resultType != null && CatalogType.Default.getString().equals(resultType) && !context.isLValue()) {
            factories.add(new PlainTextExpressionEditorFactory());
        }
        factories.add(new SimpleExpressionEditorFactory());
        factories.add(new XPathExpressionEditorFactory());
        Sequence<ExpressionEditorFactory> factoriesSequence = CollectionUtils.asSequence(factories);
        return SingleLineExpressionPanel.create(parent, factoriesSequence, context, true);
    }

    public static ExpressionPanel createUserTaskPriorityPanel(@NotNull UiContainer parent, @NotNull ExpressionContext context) {
        ArrayList<ExpressionEditorFactory> factories = new ArrayList<ExpressionEditorFactory>();
        CatalogType resultType = context.getResultType();
        if (resultType != null && CatalogType.Default.getInt().equals(resultType)) {
            NumericLOVExpressionEditorFactory numericFactory = new NumericLOVExpressionEditorFactory(CollectionUtils.asSequence(PriorityCombo.VALUES), (LabelProvider<Integer>)PriorityCombo.LABEL_PROVIDER);
            factories.add(numericFactory);
        }
        factories.add(new SimpleExpressionEditorFactory());
        factories.add(new XPathExpressionEditorFactory());
        Sequence<ExpressionEditorFactory> factoriesSequence = CollectionUtils.asSequence(factories);
        return SingleLineExpressionPanel.create(parent, factoriesSequence, context, true);
    }

    public static ExpressionPanel createNotificationPropertyPanel(@NotNull UiContainer parent, @NotNull ExpressionContext context, boolean multiLine) {
        ArrayList<ExpressionEditorFactory> factories = new ArrayList<ExpressionEditorFactory>();
        CatalogType resultType = context.getResultType();
        if (resultType != null && CatalogType.Default.getString().equals(resultType)) {
            factories.add(new PlainTextExpressionEditorFactory());
        }
        factories.add(new SimpleExpressionEditorFactory());
        factories.add(new XPathExpressionEditorFactory());
        Sequence<ExpressionEditorFactory> factoriesSequence = CollectionUtils.asSequence(factories);
        return multiLine ? MultiLineExpressionPanel.create(parent, factoriesSequence, context, false) : SingleLineExpressionPanel.create(parent, factoriesSequence, context, false);
    }

    public static ExpressionPanel createUserNotificationPropertyPanel(@NotNull UiContainer parent, @NotNull ExpressionContext context) {
        StudioWorkbench workbench;
        HumanTaskService humanTaskService;
        ArrayList<ExpressionEditorFactory> factories = new ArrayList<ExpressionEditorFactory>();
        CatalogType resultType = context.getResultType();
        if (resultType != null && CatalogType.Default.getString().equals(resultType) && (humanTaskService = (workbench = AbstractStudioWorkbench.getInstance()).getHumanTaskService()) != null) {
            Sequence<String> userNotificationHeaders = humanTaskService.getUserNotificationHeaders();
            factories.add(new TextEditableLOVExpressionEditorFactory(userNotificationHeaders));
        }
        factories.add(new SimpleExpressionEditorFactory());
        factories.add(new XPathExpressionEditorFactory());
        Sequence<ExpressionEditorFactory> factoriesSequence = CollectionUtils.asSequence(factories);
        return SingleLineExpressionPanel.create(parent, factoriesSequence, context, false);
    }

    public static ExpressionPanel createUpdatePropertyPanel(@NotNull UiContainer parent, @NotNull ExpressionContext context, boolean multiLine) {
        ArrayList<ExpressionEditorFactory> factories = new ArrayList<ExpressionEditorFactory>();
        CatalogType resultType = context.getResultType();
        if (resultType != null && CatalogType.Default.getString().equals(resultType)) {
            factories.add(new PlainTextExpressionEditorFactory());
        }
        factories.add(new SimpleExpressionEditorFactory());
        factories.add(new XPathExpressionEditorFactory());
        Sequence<ExpressionEditorFactory> factoriesSequence = CollectionUtils.asSequence(factories);
        return multiLine ? MultiLineExpressionPanel.create(parent, factoriesSequence, context, true) : SingleLineExpressionPanel.create(parent, factoriesSequence, context, true);
    }

    public static ExpressionPanel createOutcomeUpdatePanel(@NotNull UiContainer parent, @NotNull ExpressionContext context) {
        StudioWorkbench workbench;
        HumanTaskService humanTaskService;
        ArrayList<ExpressionEditorFactory> factories = new ArrayList<ExpressionEditorFactory>();
        CatalogType resultType = context.getResultType();
        if (resultType != null && CatalogType.Default.getString().equals(resultType) && (humanTaskService = (workbench = AbstractStudioWorkbench.getInstance()).getHumanTaskService()) != null) {
            Sequence<String> humanTaskOutcomes = humanTaskService.getHumanTaskOutcomes();
            factories.add(new TextEditableLOVExpressionEditorFactory(humanTaskOutcomes));
        }
        factories.add(new SimpleExpressionEditorFactory());
        factories.add(new XPathExpressionEditorFactory());
        Sequence<ExpressionEditorFactory> factoriesSequence = CollectionUtils.asSequence(factories);
        return SingleLineExpressionPanel.create(parent, factoriesSequence, context, true);
    }
}

