/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.expression.ExpressionContainer;
import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public abstract class ExpressionContainerImpl
extends Panel
implements ExpressionContainer {
    protected List<ExpressionContainerListener> listeners = new ArrayList<ExpressionContainerListener>();
    private ExpressionContext context;

    public ExpressionContainerImpl(@NotNull UiContainer parent, @NotNull ExpressionContext context) {
        super(parent);
        this.context = context;
    }

    @Override
    public void addListener(ExpressionContainerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ExpressionContainerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean rebuildWhenExpressionChanges() {
        return false;
    }

    @Override
    public boolean isExpressionValid() {
        return true;
    }

    @Override
    public void revalidateExpression() {
    }

    @Override
    public void setContext(@NotNull ExpressionContext context) {
        this.context = context;
        this.revalidateExpression();
    }

    @Override
    public ExpressionContext getContext() {
        return this.context;
    }

    protected void fireExpressionChanged() {
        for (ExpressionContainerListener listener : this.listeners) {
            listener.expressionChanged();
        }
    }
}

