/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.expression.ExpressionBuilderDialog;
import oracle.bpm.designer.expression.editorfactory.ExpressionEditorFactory;
import oracle.bpm.designer.expression.editorfactory.SimpleExpressionEditorFactory;
import oracle.bpm.designer.expression.editorfactory.XPathExpressionEditorFactory;
import oracle.bpm.designer.expression.editorfactory.XmlLiteralExpressionEditorFactory;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionBuilderFactory {
    public static ExpressionBuilderDialog createDataAssociationExpressionBuilder(@NotNull UiWindow parent, @NotNull ExpressionMode mode, @NotNull ExpressionContext context, @Nullable Expression expression) {
        ArrayList<ExpressionEditorFactory> factories = new ArrayList<ExpressionEditorFactory>();
        factories.add(new SimpleExpressionEditorFactory());
        factories.add(new XPathExpressionEditorFactory());
        factories.add(new XmlLiteralExpressionEditorFactory());
        Sequence<ExpressionEditorFactory> factoriesSequence = CollectionUtils.asSequence(factories);
        return ExpressionBuilderDialog.create(Ui.getRoot(), factoriesSequence, mode, context, expression);
    }
}

