/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.expression;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ExpressionBuilder;
import oracle.bpm.designer.expression.ExpressionBuilderPanel;
import oracle.bpm.designer.expression.editorfactory.ExpressionEditorFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

public class ExpressionBuilderDialog
extends OkCancelDialog
implements ExpressionBuilder {
    private ExpressionBuilderPanel expressionBuilderPanel;
    private boolean validateExpression = false;

    private ExpressionBuilderDialog(UiWindow parent, @NotNull Sequence<ExpressionEditorFactory> factories, @NotNull ExpressionMode selectedMode, @NotNull ExpressionContext context, Expression expression) {
        super(parent, DesignerMsg.EXPRESSION_BUILDER);
        this.init(factories, selectedMode, context, expression);
    }

    public static ExpressionBuilderDialog create(UiWindow parent, @NotNull Sequence<ExpressionEditorFactory> factories, @NotNull ExpressionMode selectedMode, @NotNull ExpressionContext context, Expression expression) {
        return new ExpressionBuilderDialog(parent, factories, selectedMode, context, expression);
    }

    public void ok() {
        if (!this.validateExpression || this.expressionBuilderPanel.isExpressionValid()) {
            this.close();
        } else {
            MessageDialog.showError((Msg)DesignerMsg.INVALID_EXPRESSION);
        }
    }

    @Override
    public Expression getExpression() {
        return this.expressionBuilderPanel.getExpression();
    }

    @Override
    public boolean showDialog() {
        this.setVisible(true);
        return this.userAccepted();
    }

    @Override
    public void setValidateExpression(boolean validateExpression) {
        this.validateExpression = validateExpression;
    }

    private void init(@NotNull Sequence<ExpressionEditorFactory> factories, @NotNull ExpressionMode mode, @NotNull ExpressionContext context, Expression expression) {
        UiContainer panel = this.getContentPane();
        panel.setLayout((Layout)new BorderLayout());
        this.expressionBuilderPanel = new ExpressionBuilderPanel(panel, factories, context);
        panel.add(this.expressionBuilderPanel.getUiComponent(), (Object)"Center");
        if (expression != null) {
            this.expressionBuilderPanel.setExpression(expression);
        } else {
            this.expressionBuilderPanel.setExpressionMode(mode);
        }
        this.setSize(750, 650);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }
}

