/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.errorview;

import oracle.bpm.designer.DesignPanel;
import oracle.bpm.designer.errorview.ErrorTable;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selection.DesignerSelection;
import oracle.bpm.designer.selection.DesignerSelectionProvider;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.model.ErrorSource;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Link;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.SizeEvent;
import oracle.bpm.ui.event.SizeListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;

public class ErrorView
extends Panel {
    private boolean first = true;
    private Link hintButton;
    private boolean isViewShowing = false;
    private int lastDivider;
    private SplitPane splitPane;
    private ErrorTable table;

    public ErrorView(Panel splitContainer, DesignPanel designPanel) {
        super((UiContainer)splitContainer);
        this.makeRecyclable();
        this.setPreferredSize(Dimension.valueOf(100, 100));
        this.setLayout((Layout)new BorderLayout());
        this.table = new ErrorTable((UiContainer)this);
        this.add((UiComponent)this.table, "Center");
        this.table.setMinimumSize(Dimension.valueOf(0, 0));
        final DesignerSelectionProvider selectionProvider = designPanel.getProcessDomain().getSelectionProvider();
        selectionProvider.addSelectionListener(new SelectionListener(){

            public void selectionChanged(Selection newSelection) {
                DesignerSelection designerSelection = selectionProvider.getSelection();
                ErrorSource source = (ErrorSource)designerSelection.as(ErrorSource.class);
                ProcessContent process = (ProcessContent)designerSelection.as(ProcessContent.class);
                ErrorView.this.table.load(source);
                ErrorView.this.updateHintButtonMessage();
            }
        });
        this.showView(false);
    }

    public UiComponent getHintButton(Panel bottomView, int height, SplitPane splitPane) {
        this.splitPane = splitPane;
        this.hintButton = new Link((UiContainer)bottomView, new BaseAction(this.table.getErrorMessage()){

            public void actionPerformed(ActionEvent e) {
                boolean show = !ErrorView.this.isViewShowing;
                ErrorView.this.showView(show);
                ErrorView.this.updateHintButtonMessage();
            }
        });
        this.hintButton.setFont(this.hintButton.getFont().smaller(2));
        this.hintButton.makeRecyclable();
        int width = this.getMinHintWidth();
        this.updateHintButtonMessage();
        this.hintButton.setPreferredSize(Dimension.valueOf(Math.max(130, width), height));
        splitPane.addSizeListener(new SizeListener(){
            boolean firstSize = true;

            public void componentResized(SizeEvent event) {
                if (ErrorView.this.first) {
                    ErrorView.this.checkViewSize();
                    this.firstSize = false;
                } else {
                    ErrorView.this.adjustIfHidden();
                }
            }
        });
        return this.hintButton;
    }

    private void updateHintButtonMessage() {
        if (this.isViewShowing) {
            this.hintButton.setMsg(DesignerMsg.HIDE_ERROR_MESSAGES);
        } else {
            Image icon;
            Msg msg;
            if (this.table.getErrorCount() > 0) {
                msg = DesignerMsg.SHOW_ERROR_MESSAGES.args(this.table.getErrorCount(), DesignerMsg.ERRORS.getString());
                icon = Image.create((Msg)DesignerMsg.SMALL_ERROR);
            } else if (this.table.getWarningCount() > 0) {
                msg = DesignerMsg.SHOW_ERROR_MESSAGES.args(this.table.getWarningCount(), DesignerMsg.WARNINGS.getString());
                icon = Image.create((Msg)DesignerMsg.SMALL_WARNING);
            } else {
                msg = DesignerMsg.SHOW_ERROR_MESSAGES.args("", DesignerMsg.NO_MESSAGES.getString());
                icon = null;
            }
            this.hintButton.setText(msg.toString());
            this.hintButton.setIcon(icon);
        }
    }

    private int getMinHintWidth() {
        this.hintButton.setMsg(DesignerMsg.SHOW_ERROR_MESSAGES.args(999, DesignerMsg.WARNINGS.getString()));
        this.hintButton.setIcon(Image.create((Msg)DesignerMsg.SMALL_WARNING));
        return this.hintButton.getPreferredSize().getWidth();
    }

    private void adjustIfHidden() {
        if (!this.isViewShowing) {
            int maxPosition = this.getMaxPosition();
            if (this.splitPane.getDividerLocation() < maxPosition) {
                this.splitPane.setDividerLocation(maxPosition);
            }
        }
    }

    private int getMaxPosition() {
        int bottomSize = this.splitPane.getBottomComponent().getMinimumSize().getHeight();
        return this.splitPane.getHeight() - bottomSize;
    }

    private void checkViewSize() {
        int newLocation = this.getMaxPosition();
        this.splitPane.setDividerVisible(false);
        this.splitPane.setDividerLocation(newLocation);
        this.lastDivider = this.getDefaultLocation();
    }

    private int getDefaultLocation() {
        return this.splitPane.getHeight() - this.splitPane.getHeight() / 4;
    }

    private void showView(boolean show) {
        if (this.first && show) {
            this.table.fixSize();
            this.first = false;
        }
        if (this.isViewShowing && this.splitPane != null && !this.first) {
            this.lastDivider = this.splitPane.getDividerLocation();
        }
        this.isViewShowing = show;
        if (this.splitPane != null) {
            int newLocation;
            int maxPosition = this.getMaxPosition();
            int n = newLocation = this.isViewShowing ? this.lastDivider : maxPosition;
            if (newLocation == 0 || newLocation > maxPosition) {
                newLocation = this.getDefaultLocation();
            }
            this.splitPane.setDividerLocation(newLocation);
            this.splitPane.setDividerVisible(this.isViewShowing);
        }
    }
}

