/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.errorview;

import java.util.List;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.project.fixes.FixRegistry;
import oracle.bpm.project.model.ErrorSource;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.resources.UIMsg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.util.FixOption;
import oracle.bpm.util.Fixable;

public class ErrorTable
extends Panel {
    private int errorCount;
    private ProviderTableModel<ErrorMessage> model;
    private Table table;
    private int warningCount;

    public ErrorTable(UiContainer parent) {
        super(parent);
        this.setLayout((Layout)new BorderLayout());
        this.table = new Table((UiContainer)this){

            protected boolean contributesToEdition() {
                return false;
            }
        };
        this.add((UiComponent)this.table);
        this.model = new ProviderTableModel<ErrorMessage>(MsgList.create(UIMsg.QUOTE(""), DesignerMsg.DESCRIPTION)){

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                return ErrorMessage.class;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                ErrorMessage message = (ErrorMessage)this.getRow(rowIndex);
                if (columnIndex == 0) {
                    return FixRegistry.getInstance().isFixable((Exception)((Object)message.exception));
                }
                return message;
            }
        };
        this.table.setModel(this.model);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                System.out.println("e.getSource() = " + e.getSource());
                int row = ErrorTable.this.table.getSelectedRow();
                ErrorMessage errorMessage = (ErrorMessage)ErrorTable.this.model.getRow(row);
                FixRegistry registry = FixRegistry.getInstance();
                if (registry.isFixable((Exception)((Object)errorMessage.exception))) {
                    FixOption[] fixOptions = registry.getFixOptionsFor((Fixable)((Object)errorMessage.exception));
                    PopupMenu pop = new PopupMenu();
                    for (final FixOption fixOption : fixOptions) {
                        BaseAction action = new BaseAction(fixOption.getDescription()){

                            public void actionPerformed(ActionEvent event) {
                                try {
                                    fixOption.fix();
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                        };
                        pop.add(action);
                    }
                    pop.show((UiComponent)ErrorTable.this.table, e.getX(), e.getY());
                }
            }
        });
        this.table.setDefaultLabelProvider(Boolean.class, (LabelProvider)new LabelProvider<Boolean>(){

            public Image getIcon(Boolean element) {
                return element != false ? Image.create((Msg)DesignerMsg.QUICK_FIX) : null;
            }

            public String getText(Boolean element) {
                return "";
            }
        });
        this.table.setDefaultLabelProvider(ErrorMessage.class, (LabelProvider)new LabelProvider<ErrorMessage>(){

            public Image getIcon(ErrorMessage element) {
                return element.getType() == ErrorMessage.Type.ERROR ? Image.create((Msg)ProjectDrawMsg.ERROR) : Image.create((Msg)ProjectDrawMsg.WARNING);
            }

            public String getText(ErrorMessage element) {
                return element.getMessage();
            }
        });
        this.fixSize();
    }

    public void load(ErrorSource source) {
        this.model.removeAllElements();
        if (source != null) {
            List nestedErrors = source.getNestedErrors();
            this.errorCount = nestedErrors.size();
            List nestedWarnings = source.getNestedWarnings();
            this.warningCount = nestedWarnings.size();
            this.load(nestedErrors, ErrorMessage.Type.ERROR);
            this.load(nestedWarnings, ErrorMessage.Type.WARNING);
        } else {
            this.warningCount = 0;
            this.errorCount = 0;
        }
        this.fixSize();
    }

    public void fixSize() {
        this.table.getColumn(0).setWidth(30);
        this.table.getColumn(1).setWidth(this.table.getWidth() - 30);
        this.table.setPreferredRows(5);
    }

    public boolean hasItems() {
        return this.model.getRowCount() > 0;
    }

    public String getErrorMessage() {
        String result = this.errorCount > 0 || this.warningCount == 0 ? DesignerMsg.ERRORS.getString() + "(" + this.errorCount + ")" : DesignerMsg.WARNINGS.getString() + "(" + this.warningCount + ")";
        return result;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    private void load(List<ProjectException> result, ErrorMessage.Type type) {
        for (ProjectException exception : result) {
            this.model.addRow((Object)new ErrorMessage(type, exception));
        }
    }

    static class ErrorMessage {
        private ProjectException exception;
        private Type type;

        ErrorMessage(Type type, ProjectException exception) {
            this.type = type;
            this.exception = exception;
        }

        public String getMessage() {
            return this.exception.getMessage();
        }

        public Type getType() {
            return this.type;
        }

        static enum Type {
            ERROR,
            WARNING;

        }
    }
}

