/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff.draw;

import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.geom.AffineTransform;
import oracle.bpm.designer.diff.draw.DrawableDifferMask;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.peer.swing.AwtConverter;
import org.jetbrains.annotations.NotNull;

class MaskRenderer
implements Renderer {
    public int MINIMUM_HEIGHT;
    private DrawableDifferMask mask;
    private static final Color[] AWT_COLORS = new Color[]{AwtConverter.toAwt((oracle.bpm.draw.Color)oracle.bpm.draw.Color.TRANSPARENT), AwtConverter.toAwt((oracle.bpm.draw.Color)oracle.bpm.draw.Color.valueOf((oracle.bpm.draw.Color)oracle.bpm.draw.Color.BLACK, (int)110))};
    private static final float[] DIST = new float[]{0.75f, 1.0f};

    private MaskRenderer(@NotNull DrawableDifferMask mask) {
        this.mask = mask;
    }

    public void render() {
        DiagramContext context = this.getContext();
        int radius = this.mask.getHighlightRadius();
        int width = this.mask.getHighlightWidth();
        if (width != 0) {
            Graphics graphics = context.getGraphics();
            graphics.setAntialiasing(AntialiasingMode.ON);
            Rectangle bounds = context.scale(this.mask.getBounds());
            Point center = new Point(bounds.getCenterX(), bounds.getCenterY());
            Paint original = graphics.getPaint();
            AffineTransform gradientTransform = new AffineTransform();
            gradientTransform.translate(center.getX(), center.getY());
            this.MINIMUM_HEIGHT = 15;
            int highlightHeight = this.mask.getHighlightHeight() != 0 ? this.mask.getHighlightHeight() : this.MINIMUM_HEIGHT;
            gradientTransform.scale(1.0, (double)highlightHeight / (double)width);
            gradientTransform.translate(-center.getX(), -center.getY());
            graphics.setPaint((Paint)new RadialGradientPaint(center, (float)radius * 1.1f, center, DIST, AWT_COLORS, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, gradientTransform));
            graphics.fill(context.scale(bounds));
            graphics.setPaint(original);
        }
    }

    static Renderer create(DrawableDifferMask mask) {
        return new MaskRenderer(mask);
    }

    private DiagramContext getContext() {
        return this.mask.getContext();
    }
}

