/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff.draw;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.designer.diff.DiffBase;
import oracle.bpm.designer.diff.DifferProcess;
import oracle.bpm.designer.diff.DifferUniverse;
import oracle.bpm.designer.diff.draw.DrawableDifferProcess;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.geom.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DrawableDifferUniverse
extends DrawableImpl<DifferUniverse> {
    private static final ProcessPredicate LOCAL_DRAWABLE = new ProcessPredicate(DiffBase.LOCAL);
    private static final ProcessPredicate REMOTE_DRAWABLE = new ProcessPredicate(DiffBase.REMOTE);
    private static final ProcessPredicate RESULT_DRAWABLE = new ProcessPredicate(DiffBase.RESULT);
    public static final int PROCESSES_GAP = 30;

    DrawableDifferUniverse(@NotNull Drawable container, @NotNull DifferUniverse universe) {
        super(container, (Object)universe, DesignerLayer.PROCESS);
    }

    public void refresh() {
        int height = this.getHeight() / 2 - 30;
        int yLocation = this.getHeight() / 4;
        int xLocation = this.getWidth() / 4;
        int topProcessWidth = this.getWidth() / 2 - 30;
        int topProcessYLocation = yLocation - 15;
        int bottomProcessYLocation = yLocation * 3 - 15;
        int bottomProcessWidth = this.getWidth() - 30;
        this.refresh(this.getLocalDrawable(), topProcessWidth, height, xLocation, topProcessYLocation);
        this.refresh(this.getRemoteDrawable(), topProcessWidth, height, xLocation * 3, topProcessYLocation);
        this.refresh(this.getResultDrawable(), bottomProcessWidth, height, xLocation * 2, bottomProcessYLocation);
        this.setLocation(new Point(this.getWidth() / 2, this.getHeight() / 2));
    }

    DrawableDifferProcess getLocalDrawable() {
        return this.get(LOCAL_DRAWABLE);
    }

    DrawableDifferProcess getRemoteDrawable() {
        return this.get(REMOTE_DRAWABLE);
    }

    DrawableDifferProcess getResultDrawable() {
        return this.get(RESULT_DRAWABLE);
    }

    private void refresh(DrawableDifferProcess drawable, int width, int height, int xLocation, int yLocation) {
        drawable.setWidth(width);
        drawable.setHeight(height);
        drawable.setLocation(new Point(xLocation, yLocation));
        drawable.refresh();
    }

    private DrawableDifferProcess get(ProcessPredicate predicate) {
        return (DrawableDifferProcess)CollectionUtils.first(this.getDrawables().select(predicate));
    }

    private static class ProcessPredicate
    implements Predicate<Drawable> {
        private final DiffBase expectedType;

        public ProcessPredicate(DiffBase expectedType) {
            this.expectedType = expectedType;
        }

        @Override
        public boolean check(@Nullable Drawable value) {
            return value != null && value instanceof DrawableDifferProcess && ((DifferProcess)((DrawableDifferProcess)value).getModelObject()).getBase() == this.expectedType;
        }
    }
}

