/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff.draw;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.diff.DifferProcess;
import oracle.bpm.designer.diff.draw.DrawableDifferMask;
import oracle.bpm.designer.diff.draw.DrawableDifferPoolLabel;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

class DrawableDifferProcess
extends DrawableImpl<DifferProcess>
implements Renderer {
    private DrawableDifferPoolLabel name;
    public static final int POOL_OFFSET = 10;

    DrawableDifferProcess(@NotNull Drawable container, @NotNull DifferProcess process) {
        super(container, (Object)process, DesignerLayer.PROCESS);
        this.name = new DrawableDifferPoolLabel(container, this);
        this.attachRenderer(this);
    }

    public void refresh() {
        this.getMaskDrawable().refresh();
        this.name.refresh();
        super.refresh();
    }

    public void add() {
        super.add();
        this.name.add();
    }

    public void remove() {
        super.remove();
        this.name.remove();
    }

    public void render() {
        Rectangle bounds = this.getContext().scale(this.getBounds());
        Graphics graphics = this.getContext().getGraphics();
        Color original = graphics.getForeground();
        graphics.setForeground(((DifferProcess)this.getModelObject()).getBase().getColor());
        graphics.fillRoundRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), 10, 10);
        graphics.setForeground(Color.BLACK);
        graphics.drawRoundRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), 10, 10);
        graphics.setForeground(original);
    }

    DrawableDifferMask getMaskDrawable() {
        return CollectionUtils.first(CollectionUtils.selectInstanceOf(this.getDrawables(), DrawableDifferMask.class));
    }
}

