/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff.draw;

import oracle.bpm.designer.diff.DifferProcess;
import oracle.bpm.designer.diff.draw.DrawableDifferProcess;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableLabel;
import oracle.bpm.diagram.draw.DrawableVerticalLabel;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.geom.Insets;
import oracle.bpm.lang.Str;
import org.jetbrains.annotations.NotNull;

public class DrawableDifferPoolLabel
extends DrawableVerticalLabel<DifferProcess> {
    private String truncatedLabel;

    public DrawableDifferPoolLabel(@NotNull Drawable container, @NotNull DrawableDifferProcess owner) {
        super(container, (Drawable)owner, DesignerLayer.PROCESS);
        this.setLabelLocation(DrawableLabel.LabelLocation.CENTER_LEFT);
        this.setHorizontalAlignment(DrawableLabel.HorizontalAlignment.LEFT);
        this.setVerticalAlignment(DrawableLabel.VerticalAlignment.CENTER);
        this.setInsets(Insets.valueOf(0, -5, 0, 0));
    }

    public Font getFont() {
        DrawContext context = this.getContext();
        Font font = context.getTheme().getLaneFont(this.isShowSelection());
        return font.larger(2);
    }

    @NotNull
    public String getLabel() {
        if (this.truncatedLabel == null) {
            DifferProcess process = (DifferProcess)this.getModelObject();
            return Str.capitalize(process.getBase().name().toLowerCase()) + ": " + process.getMask().getProcess().getDefaultLabel();
        }
        return this.truncatedLabel;
    }

    public void refresh() {
        this.truncatedLabel = null;
        super.refresh();
    }

    @NotNull
    public DrawContext getContext() {
        return (DrawContext)super.getContext();
    }

    protected int calculateLabelHeight(@NotNull String label, @NotNull FontMetrics metrics) {
        int height = metrics.stringWidth(label);
        this.truncatedLabel = label;
        int ownerHeight = this.getOwnerBounds().getHeight();
        while (height > this.getContext().scale(ownerHeight) && label.length() > 0) {
            label = label.substring(0, label.length() - 1);
            this.truncatedLabel = label + "...";
            height = metrics.stringWidth(this.truncatedLabel);
        }
        return height;
    }

    protected Color getLabelBackgroundColor() {
        return ((DifferProcess)this.getModelObject()).getBase().getColor();
    }

    protected String getSpecificLabelIdentification() {
        return String.valueOf((Object)((DifferProcess)this.getModelObject()).getBase());
    }
}

