/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff.draw;

import oracle.bpm.collections.Predicate;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableNodeContainerImpl;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DrawableDifferPool
extends DrawableNodeContainerImpl<Process> {
    private static final Predicate<Drawable> NOT_HIDDEN_PREDICATE = new Predicate<Drawable>(){

        @Override
        public boolean check(@Nullable Drawable drawable) {
            return drawable != null && !drawable.isHidden() && !DesignerLayer.LABEL.equals((Object)drawable.getLayer());
        }
    };

    DrawableDifferPool(Drawable container, @NotNull Process process) {
        super(container, (NodeContainer)process, DesignerLayer.PROCESS);
    }

    public void refresh() {
        Dimension dimension = this.getDimension();
        this.setWidth(dimension.getWidth());
        this.setHeight(dimension.getHeight());
        this.setLocation(new Point(this.getWidth() / 2, this.getHeight() / 2));
        super.refresh();
    }

    private Dimension getDimension() {
        int maxX = 0;
        int maxY = 0;
        for (Drawable child : this.getDrawables().select(NOT_HIDDEN_PREDICATE)) {
            if (!(child instanceof DrawableFlowElement)) continue;
            DrawableFlowElement element = (DrawableFlowElement)child;
            int rightBound = element.getRightBound();
            maxX = Math.max(maxX, rightBound);
            int underBound = element.getUnderBound();
            maxY = Math.max(maxY, underBound);
        }
        return Dimension.valueOf(maxX * 2, maxY * 2);
    }
}

