/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff.draw;

import oracle.bpm.command.Command;
import oracle.bpm.designer.diff.draw.DrawableDifferMask;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.drag.DraggableCapability;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

class DragDifferPoolCapability
extends DraggableCapability {
    private Point distance;

    DragDifferPoolCapability(@NotNull CapableController controller) {
        super(controller);
    }

    public void startDrag(@NotNull CapabilityEvent event) {
        this.distance = event.getLocation().sub(this.getDrawable().getLocation());
        this.getDrawableMask().setHighlightRadius(0);
    }

    public void drag(@NotNull CapabilityEvent event) {
        Point location = event.getLocation().sub(this.distance);
        this.getDrawable().setLocation(location);
        Drawable process = this.getDrawableDifferProcess();
        Rectangle repaint = process.getBounds();
        this.getDomain().getCanvas().paintImmediately(repaint);
    }

    public void endDrag(@NotNull CapabilityEvent event) {
    }

    public Command process(@NotNull CapabilityEvent event) {
        return null;
    }

    private Drawable getDrawable() {
        return this.getController().getDrawableObject();
    }

    private DrawableDifferMask getDrawableMask() {
        return (DrawableDifferMask)this.getDrawable().getContainer();
    }

    private Drawable getDrawableDifferProcess() {
        return this.getContainer().getContainer();
    }

    private Drawable getContainer() {
        return this.getDrawable().getContainer();
    }
}

