/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff.draw;

import oracle.bpm.designer.diff.DifferProcess;
import oracle.bpm.designer.diff.DifferUniverse;
import oracle.bpm.designer.diff.HighlightElementAware;
import oracle.bpm.designer.diff.draw.DrawableDifferMask;
import oracle.bpm.designer.diff.draw.DrawableDifferProcess;
import oracle.bpm.designer.diff.draw.DrawableDifferUniverse;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableUtils;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllerImpl;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.diagram.editor.animation.Animation;
import oracle.bpm.diagram.editor.animation.AnimationBuilder;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class DifferUniverseController
extends ControllerImpl<DifferUniverse>
implements HighlightElementAware {
    public DifferUniverseController(@NotNull Controller container, @NotNull DrawableDifferUniverse drawable) {
        super(container, (Drawable)drawable);
    }

    @NotNull
    public DrawableDifferUniverse getDrawableObject() {
        return (DrawableDifferUniverse)super.getDrawableObject();
    }

    @Override
    public void highlight(ProjectObject element) {
        DrawableDifferUniverse universe = this.getDrawableObject();
        DrawableDifferProcess local = this.getDrawableObject().getLocalDrawable();
        this.setupHighlightBounds(local, element);
        DrawableDifferProcess remote = this.getDrawableObject().getRemoteDrawable();
        this.setupHighlightBounds(remote, element);
        DrawableDifferProcess result = this.getDrawableObject().getResultDrawable();
        this.setupHighlightBounds(result, element);
    }

    private void setupHighlightBounds(DrawableDifferProcess process, ProjectObject highlight) {
        int desiredY;
        int desiredX;
        int desiredRadius;
        Point target;
        ProjectObject element = this.findElement(process, highlight);
        final DrawableDifferMask mask = process.getMaskDrawable();
        Drawable pool = mask.getDifferPool();
        Drawable drawable = element != null ? DrawableUtils.findDrawable((Drawable)pool, (Object)element) : null;
        final int radius = mask.getHighlightRadius();
        final int width = mask.getHighlightWidth();
        final int height = mask.getHighlightHeight();
        if (drawable != null) {
            Point location = drawable.getContainer().getAbsoluteOffset().add(drawable.getLocation());
            Point center = mask.getContainer().getAbsoluteOffset().add(mask.getLocation());
            target = pool.getLocation().sub(location.sub(center));
            desiredRadius = this.getContext().scale(drawable.getBounds().diagonal());
            desiredX = this.getContext().scale(drawable.getBounds().getWidth());
            desiredY = this.getContext().scale(drawable.getBounds().getHeight());
        } else {
            target = new Point(pool.getWidth() / 2, pool.getHeight() / 2);
            desiredX = 0;
            desiredRadius = 0;
            desiredY = 0;
        }
        Animation radial = new Animation(){

            public void interpolate(@NotNull Drawable drawable, float percentage) {
                if (width != desiredX || height != desiredY) {
                    mask.setHighlightWidth((int)((float)width - (float)(width - desiredX) * percentage / 100.0f));
                    mask.setHighlightHeight((int)((float)height - (float)(height - desiredY) * percentage / 100.0f));
                    mask.setHighlightRadius((int)((float)radius - (float)(radius - desiredRadius) * percentage / 100.0f));
                }
            }
        };
        AnimationBuilder.create((Drawable)pool).slower().animate(Animation.translate((Point)pool.getLocation(), (Point)target)).animate(radial).animate(Animation.repaint((Domain)this.getDomain())).start();
    }

    private ProjectObject findElement(DrawableDifferProcess process, ProjectObject highlight) {
        Object searchScope = highlight instanceof Process || highlight.getParentObject() instanceof Process ? ((DifferProcess)process.getModelObject()).getProcess() : (ProjectObjectContainer)this.findElement(process, highlight.getParentObject());
        return searchScope.findChild(highlight.getRawClass(), highlight.getId());
    }

    private DiagramContext getContext() {
        return this.getDrawableObject().getContext();
    }
}

