/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff.draw;

import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.designer.diff.DifferMask;
import oracle.bpm.designer.diff.DifferProcess;
import oracle.bpm.designer.diff.DifferUniverse;
import oracle.bpm.designer.diff.draw.DrawableDifferMask;
import oracle.bpm.designer.diff.draw.DrawableDifferPool;
import oracle.bpm.designer.diff.draw.DrawableDifferProcess;
import oracle.bpm.designer.diff.draw.DrawableDifferUniverse;
import oracle.bpm.designer.diff.draw.MaskRenderer;
import oracle.bpm.diagram.draw.ChildrenPopulator;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableCreator;
import oracle.bpm.diagram.draw.renderer.ChildrenRenderer;
import oracle.bpm.diagram.draw.renderer.DebugContainerRenderer;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.BpmnDrawableFactory;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

class DifferDrawableFactory
extends BpmnDrawableFactory {
    private static DifferDrawableFactory instance;

    DifferDrawableFactory() {
    }

    public static DifferDrawableFactory getInstance() {
        if (instance == null) {
            instance = new DifferDrawableFactory();
        }
        return instance;
    }

    protected void creators() {
        this.creator(this.differUniverseCreator());
        this.creator(this.differProcessCreator());
        this.creator(this.differMaskCreator());
        super.creators();
    }

    protected void populators() {
        this.populator(this.collaborationUniversePopulator());
        this.populator(this.collaborationProcessPopulator());
        this.populator(this.collaborationMaskPopulator());
        super.populators();
    }

    protected DrawableCreator processCreator() {
        return new DrawableCreator<Process>(Process.class){

            protected Drawable create(@NotNull Drawable container, @NotNull Process process) {
                DrawableDifferPool drawable = new DrawableDifferPool(container, process);
                drawable.attachRenderer((Renderer)ChildrenRenderer.createClipped((Drawable)drawable));
                drawable.attachRenderer((Renderer)DebugContainerRenderer.create((Drawable)drawable));
                return drawable;
            }
        };
    }

    protected ChildrenPopulator processPopulator() {
        return new BpmnDrawableFactory.NodeContainerPopulator<Process>(Process.class){

            protected void append(@NotNull List<Object> result, @NotNull Process process) {
            }
        };
    }

    private DrawableCreator differUniverseCreator() {
        return new DrawableCreator<DifferUniverse>(DifferUniverse.class){

            protected Drawable create(@NotNull Drawable container, @NotNull DifferUniverse universe) {
                DrawableDifferUniverse drawable = new DrawableDifferUniverse(container, universe);
                drawable.attachRenderer((Renderer)ChildrenRenderer.createClipped((Drawable)drawable));
                drawable.attachRenderer((Renderer)DebugContainerRenderer.create((Drawable)drawable));
                return drawable;
            }
        };
    }

    private DrawableCreator differProcessCreator() {
        return new DrawableCreator<DifferProcess>(DifferProcess.class){

            protected Drawable create(@NotNull Drawable container, @NotNull DifferProcess process) {
                DrawableDifferProcess drawable = new DrawableDifferProcess(container, process);
                drawable.attachRenderer((Renderer)ChildrenRenderer.createClipped((Drawable)drawable));
                drawable.attachRenderer((Renderer)DebugContainerRenderer.create((Drawable)drawable));
                return drawable;
            }
        };
    }

    private DrawableCreator differMaskCreator() {
        return new DrawableCreator<DifferMask>(DifferMask.class){

            protected Drawable create(@NotNull Drawable container, @NotNull DifferMask mask) {
                DrawableDifferMask drawable = new DrawableDifferMask(container, mask);
                drawable.attachRenderer((Renderer)ChildrenRenderer.createClipped((Drawable)drawable));
                drawable.attachRenderer((Renderer)DebugContainerRenderer.create((Drawable)drawable));
                drawable.attachRenderer(MaskRenderer.create(drawable));
                return drawable;
            }
        };
    }

    private ChildrenPopulator collaborationUniversePopulator() {
        return new ChildrenPopulator<DifferUniverse>(DifferUniverse.class){

            protected Iterable populate(@NotNull DifferUniverse universe) {
                return SequenceBuilder.create(universe.getLocal()).append(universe.getRemote()).append(universe.getResult()).build();
            }
        };
    }

    private ChildrenPopulator collaborationProcessPopulator() {
        return new ChildrenPopulator<DifferProcess>(DifferProcess.class){

            protected Iterable populate(@NotNull DifferProcess process) {
                return CollectionUtils.singletonSequence(process.getMask());
            }
        };
    }

    private ChildrenPopulator collaborationMaskPopulator() {
        return new ChildrenPopulator<DifferMask>(DifferMask.class){

            protected Iterable populate(@NotNull DifferMask mask) {
                return CollectionUtils.singletonSequence(mask.getProcess());
            }
        };
    }
}

