/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff.draw;

import oracle.bpm.designer.diff.draw.DifferUniverseController;
import oracle.bpm.designer.diff.draw.DragDifferPoolCapability;
import oracle.bpm.designer.diff.draw.DrawableDifferPool;
import oracle.bpm.designer.diff.draw.DrawableDifferUniverse;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllerCreator;
import oracle.bpm.diagram.editor.GenericControllerFactory;
import oracle.bpm.diagram.editor.capability.Capability;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.CapableControllerImpl;
import oracle.bpm.diagram.editor.capability.focus.FocusCapability;
import oracle.bpm.diagram.editor.capability.selection.ElementSelectionCapability;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class DifferControllerFactory
extends GenericControllerFactory {
    private static DifferControllerFactory instance;

    private DifferControllerFactory() {
        this.creator(this.differUniverseCreator());
        this.creator(this.processCreator());
    }

    public static DifferControllerFactory getInstance() {
        if (instance == null) {
            instance = new DifferControllerFactory();
        }
        return instance;
    }

    private ControllerCreator differUniverseCreator() {
        return new ControllerCreator<DrawableDifferUniverse>(DrawableDifferUniverse.class){

            protected Controller create(@NotNull Controller container, @NotNull DrawableDifferUniverse drawable) {
                return new DifferUniverseController(container, drawable);
            }
        };
    }

    private ControllerCreator<DrawableDifferPool> processCreator() {
        return new ControllerCreator<DrawableDifferPool>(DrawableDifferPool.class){

            protected Controller create(@NotNull Controller container, @NotNull DrawableDifferPool pool) {
                CapableControllerImpl<Process> controller = new CapableControllerImpl<Process>(container, (Drawable)pool){};
                controller.install((Capability)new FocusCapability((CapableController)controller));
                controller.install((Capability)new ElementSelectionCapability((CapableController)controller));
                controller.install((Capability)new DragDifferPoolCapability((CapableController)controller));
                return controller;
            }
        };
    }
}

