/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff.draw;

import oracle.bpm.designer.diff.draw.DifferDomain;
import oracle.bpm.designer.diff.draw.DifferDrawableFactory;
import oracle.bpm.designer.diff.draw.DifferUniverseController;
import oracle.bpm.designer.diff.draw.DrawableDifferUniverse;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.ControllerFactory;
import oracle.bpm.diagram.editor.ControllerImpl;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.UiContainer;

public class DifferCanvas
extends PaintCanvas {
    private final DifferDomain domain;
    private final ControllerImpl.RootController root;

    DifferCanvas(UiContainer parent, DifferDomain domain) {
        super(parent);
        this.setLayout(null);
        this.domain = domain;
        this.root = this.initializeRoot();
    }

    public void paintCanvas(Graphics graphics) {
        graphics.setAntialiasing(AntialiasingMode.ON);
        DiagramContext context = this.getContext();
        context.setGraphics(graphics);
        Rectangle rectangle = this.getParent().getVisibleRect();
        DrawableDifferUniverse drawable = this.getDrawableUniverse();
        drawable.setWidth(Math.max(600, rectangle.getWidth()));
        drawable.setHeight(Math.max(400, rectangle.getHeight()));
        drawable.refresh();
        drawable.draw();
    }

    public Dimension getPreferredSize() {
        return Dimension.ZERO;
    }

    public DrawableDifferUniverse getDrawableUniverse() {
        return this.getUniverseController().getDrawableObject();
    }

    public DifferUniverseController getUniverseController() {
        return (DifferUniverseController)this.root.getHolder().getControllerFor((Object)this.domain.getDomainElement());
    }

    private ControllerImpl.RootController initializeRoot() {
        DrawableImpl.DrawableRoot drawable = new DrawableImpl.DrawableRoot((PaintCanvas)this, this.domain.getContext());
        ControllerImpl.RootController controller = new ControllerImpl.RootController(this.domain, drawable){

            public void refresh() {
                DifferDrawableFactory drawableFactory = DifferCanvas.this.domain.getDrawableFactory();
                ControllerFactory controllerFactory = DifferCanvas.this.domain.getControllerFactory();
                Drawable drawable = drawableFactory.create(this.getDrawableObject(), DifferCanvas.this.domain.getDomainElement());
                Controller controller = controllerFactory.create((Controller)this, drawable);
                controller.refresh();
                controller.add();
            }
        };
        controller.refresh();
        return controller;
    }

    private DiagramContext getContext() {
        return this.domain.getContext();
    }
}

