/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff;

import java.io.File;
import java.util.Iterator;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.diff.DiffBase;
import oracle.bpm.designer.diff.DifferUniverse;
import oracle.bpm.designer.diff.ProjectObjectChangeSetTreeNode;
import oracle.bpm.designer.diff.ProjectObjectChangeTreeNode;
import oracle.bpm.designer.diff.draw.DifferCanvas;
import oracle.bpm.designer.diff.draw.DifferDomain;
import oracle.bpm.designer.diff.draw.DifferUniverseController;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.command.design.InsertActivityInTransitionCommand;
import oracle.bpm.project.command.design.LayoutModelCommand;
import oracle.bpm.project.command.design.RemoveActivityCommand;
import oracle.bpm.project.differ.NewProcessDiffer;
import oracle.bpm.project.differ.ProjectObjectChange;
import oracle.bpm.project.differ.ProjectObjectChangeSet;
import oracle.bpm.project.differ.RemovedProjectObjectChange;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.ExtendedColorProvider;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class VisualProcessDiffer {
    private static String activityId;
    private static String taskActivityId;
    private static String scriptId;
    private static SequenceFlow sequenceFlow;

    public static boolean merge(@NotNull Process local, @NotNull Process remote, @NotNull Process result, @NotNull ProjectObjectChangeSet changes, String helpId) {
        VisualProcessDifferDialog dialog = new VisualProcessDifferDialog(Ui.getRoot(), local, remote, result, changes, helpId);
        dialog.setVisible(true);
        return dialog.userAccepted();
    }

    public static void main(String[] args) throws ProjectException {
        FileProjectRepository repository = FileProjectRepository.create((File)new File("/tmp/differ/"));
        Project project = repository.create("project.differ");
        Process processA = VisualProcessDiffer.createBaseProcess(project, "Process A blalblalbjalbjaskjvalksdjvklwjalkcjesakfjiaweojfio", false);
        Process processB = (Process)processA.copy();
        processB.setDefaultLabel("Process B blalblalbjalbjaskjvalksdjvklwjalkcjesakfjiaweojfio");
        VisualProcessDiffer.modify(processB);
        Process processC = (Process)processB.copy();
        processC.setDefaultLabel("Process C blalblalbjalbjaskjvalksdjvklwjalkcjesakfjiaweojfio");
        ProjectObjectChangeSet changes = NewProcessDiffer.changes((Process)processA, (Process)processB);
        changes.append((ProjectObjectChange)new RemovedProjectObjectChange((ProjectObject)processA.findActivity(activityId).getOutgoingSequenceFlows().iterator().next()));
        VisualProcessDiffer.merge(processA, processB, processC, changes, "bpa_merge");
    }

    private static void modify(Process process) {
        Activity script = process.findActivity(scriptId);
        new RemoveActivityCommand((FlowNode)script).execute();
        new LayoutModelCommand(process, false).execute();
        Activity activity = process.findActivity(activityId);
        activity.setDefaultLabel("Oooops Activity!");
        try {
            sequenceFlow = (SequenceFlow)activity.getOutgoingSequenceFlows().iterator().next();
            sequenceFlow.delete();
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
        activity.setLocation(activity.getLocation().translate(10, 50));
        Activity task = process.findActivity(taskActivityId);
        task.setLocation(task.getLocation().translate(15, -60));
    }

    private static Process createBaseProcess(Project project, String id, boolean modifiy) throws ProjectException {
        Process process = project.createModel(id);
        Activity activity = process.createActivity();
        activity.setDefaultLabel("First Activity");
        activityId = activity.getId();
        process.addChild((ProjectObject)activity);
        new InsertActivityInTransitionCommand((FlowNode)activity, (SequenceFlow)CollectionUtils.first(process.getSequenceFlows())).execute();
        ExclusiveGateway gateway = process.createExclusiveGateway();
        gateway.setDefaultLabel("Exclusive Gateway");
        process.addChild((ProjectObject)gateway);
        new InsertActivityInTransitionCommand((FlowNode)gateway, (SequenceFlow)CollectionUtils.last(process.getSequenceFlows())).execute();
        UserTask task = process.createActivity().toUserTask();
        task.setDefaultLabel("User Task");
        taskActivityId = task.getId();
        process.addChild((ProjectObject)task);
        new InsertActivityInTransitionCommand((FlowNode)task, (SequenceFlow)CollectionUtils.last(process.getSequenceFlows())).execute();
        ScriptTask script = process.createActivity().toScriptTask();
        script.setDefaultLabel("Script Task");
        scriptId = script.getId();
        process.addChild((ProjectObject)script);
        SequenceFlow gateToScript = process.createSequenceFlow((FlowNode)gateway, (FlowNode)script);
        process.addChild((ProjectObject)gateToScript);
        SequenceFlow scriptToEnd = process.createSequenceFlow((FlowNode)script, (FlowNode)ModelUtils.getAnyEndEvent((NodeContainer)process));
        process.addChild((ProjectObject)scriptToEnd);
        new LayoutModelCommand(process, false).execute();
        project.addProcess(process);
        return process;
    }

    private static class VisualProcessDifferDialog
    extends OkCancelDialog {
        private final ProjectObjectChangeSet changes;
        private String helpId;
        private final Process local;
        private final Process remote;
        private final Process result;

        private VisualProcessDifferDialog(UiWindow parent, @NotNull Process local, @NotNull Process remote, @NotNull Process result, @NotNull ProjectObjectChangeSet changes, String helpId) {
            super(parent, DesignerMsg.PROCESS_DIFFERENCES);
            this.local = local;
            this.remote = remote;
            this.changes = changes;
            this.result = result;
            this.helpId = helpId;
            this.init();
        }

        public void ok() {
            this.setVisible(false);
        }

        public String getHelpId() {
            return this.helpId;
        }

        private static TreeSelectionListener createTreeListener(final @NotNull DifferCanvas canvas) {
            return new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent event) {
                    Object node = event.getNewLeadSelectionPath().getLastPathComponent();
                    if (node instanceof ProjectObjectChangeTreeNode) {
                        ProjectObjectChangeTreeNode change = (ProjectObjectChangeTreeNode)((Object)node);
                        ProjectObject object = change.getUserObject().getAffectedProjectObject();
                        DifferUniverseController aware = canvas.getUniverseController();
                        aware.highlight(object);
                        canvas.repaint();
                    }
                }
            };
        }

        private void init() {
            SplitPane splitPane = new SplitPane((UiContainer)this, 1);
            splitPane.setDividerLocation(280);
            Panel treePanel = new Panel((UiContainer)splitPane, DesignerMsg.DIFFERENCES);
            treePanel.setLayout((Layout)new BorderLayout());
            Tree tree = this.createTree(treePanel, this.changes);
            treePanel.add((UiComponent)tree, (Object)"Center");
            Panel panel = new Panel((UiContainer)splitPane, DesignerMsg.PROCESSES);
            panel.setLayout((Layout)new MigLayout("fill, gap 0, ins 0"));
            DifferUniverse universe = DifferUniverse.create(this.local, this.remote, this.result, this.changes);
            DifferDomain domain = new DifferDomain((UiContainer)panel, universe);
            panel.add((UiComponent)domain.getCanvas(), (Object)"grow");
            DifferCanvas canvas = domain.getCanvas();
            TreeSelectionListener listener = VisualProcessDifferDialog.createTreeListener(canvas);
            tree.addTreeSelectionListener(listener);
            splitPane.add((UiComponent)treePanel);
            splitPane.add((UiComponent)panel);
            this.getContentPane().add((UiComponent)splitPane);
            this.setMinimumSize(Dimension.valueOf(900, 650));
            this.pack();
            this.setLocationRelativeTo(null);
        }

        private Tree createTree(Panel parent, ProjectObjectChangeSet changes) {
            Tree tree = new Tree((UiContainer)parent, true);
            tree.setColorProvider((ColorProvider)new ExtendedColorProvider.Default(){

                public Color getBackgroundSelectionColor(Object element) {
                    return this.getBackground(element);
                }

                public Color getBackgroundNonSelectionColor(Object element) {
                    return this.getBackground(element);
                }

                public Color getBackground(Object element) {
                    Color result = element instanceof ProjectObjectChangeTreeNode && !(element instanceof ProjectObjectChangeSetTreeNode) ? ((ProjectObjectChangeTreeNode)((Object)element)).getBase().getColor() : Color.WHITE;
                    return result;
                }
            });
            ProjectObjectChangeSetTreeNode root = new ProjectObjectChangeSetTreeNode(changes, DiffBase.LOCAL);
            tree.setRoot((TreeNode)root);
            Iterator i$ = root.iterator();
            while (i$.hasNext()) {
                TreeNode child = (TreeNode)i$.next();
                child.expand();
            }
            return tree;
        }
    }
}

