/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff;

import oracle.bpm.designer.AbstractTreeNode;
import oracle.bpm.designer.diff.DiffBase;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.differ.ProjectObjectChange;
import oracle.bpm.project.differ.ProjectObjectChangeType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class ProjectObjectChangeTreeNode
extends AbstractTreeNode {
    private DiffBase base;

    public ProjectObjectChangeTreeNode(@NotNull ProjectObjectChange change, @NotNull DiffBase base) {
        this.base = base;
        this.setUserObject(change);
    }

    public Image getIcon() {
        Image result;
        switch (this.getUserObject().getType()) {
            case ADD: {
                result = Image.create((Msg)DesignerMsg.ADD);
                break;
            }
            case REMOVE: {
                result = Image.create((Msg)DesignerMsg.REMOVE);
                break;
            }
            case MODIFY: {
                result = Image.create((Msg)DesignerMsg.EDIT);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public String getText() {
        return this.getUserObject().getType() == ProjectObjectChangeType.MODIFY ? this.getUserObject().toString() : this.getUserObject().getType().getMessage() + " " + this.getUserObject().getAffectedProjectObject();
    }

    public DiffBase getBase() {
        return this.base;
    }

    public void setBase(DiffBase base) {
        this.base = base;
    }

    public ProjectObjectChange getUserObject() {
        return (ProjectObjectChange)super.getUserObject();
    }
}

