/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.diff;

import java.util.Iterator;
import oracle.bpm.designer.diff.DiffBase;
import oracle.bpm.designer.diff.ProjectObjectChangeTreeNode;
import oracle.bpm.project.differ.ProjectObjectChange;
import oracle.bpm.project.differ.ProjectObjectChangeSet;
import oracle.bpm.project.differ.ProjectObjectChangeType;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class ProjectObjectChangeSetTreeNode
extends ProjectObjectChangeTreeNode {
    public ProjectObjectChangeSetTreeNode(@NotNull ProjectObjectChangeSet change, @NotNull DiffBase base) {
        super((ProjectObjectChange)change, base);
        this.setBase(base);
    }

    @Override
    public DiffBase getBase() {
        DiffBase base = null;
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            TreeNode node = (TreeNode)i$.next();
            ProjectObjectChangeTreeNode child = (ProjectObjectChangeTreeNode)node;
            if (base == null) {
                base = child.getBase();
                continue;
            }
            if (base == child.getBase()) continue;
            base = DiffBase.RESULT;
            break;
        }
        return base;
    }

    @Override
    public Image getIcon() {
        return ProjectObjectRenderer.Default.getIcon((ProjectObject)this.getUserObject().getAffectedProjectObject());
    }

    public ProjectObjectChangeSet getUserObject() {
        return (ProjectObjectChangeSet)super.getUserObject();
    }

    @Override
    public String getText() {
        String name = this.getUserObject().getAffectedProjectObject() instanceof Localizable ? ((Localizable)this.getUserObject().getAffectedProjectObject()).getDefaultLabel() : this.getUserObject().getAffectedProjectObject().getName();
        return name + " (" + ProjectObjectChangeType.MODIFY.getMessage() + ')';
    }

    protected void onLoading() {
        ProjectObjectChangeSet object = this.getUserObject();
        for (ProjectObjectChange change : object.getChanges()) {
            this.add(new ProjectObjectChangeTreeNode(change, super.getBase()));
        }
        for (ProjectObjectChange change : object.getChildren()) {
            this.add(new ProjectObjectChangeSetTreeNode((ProjectObjectChangeSet)change, super.getBase()));
        }
    }
}

