/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.datadeclaration.tree;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationContainerTreeNode;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationEditAction;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationExplorerTreeNode;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationRemoveAction;
import oracle.bpm.designer.renderers.DataDeclarationRenderer;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.draw.Color;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationTreeNode
extends DataDeclarationExplorerTreeNode {
    public DataDeclarationTreeNode(Object object) {
        super(object);
    }

    public DataDeclarationTreeNode(@NotNull DataDeclaration dataDeclaration) {
        super(dataDeclaration);
    }

    public int getColorModifiers() {
        return this.isShadowed() ? Color.LIGHT_GRAY.getRGB() : Color.BLACK.getRGB();
    }

    public Image getIcon() {
        DataDeclaration dataDeclaration = this.getDataDeclaration();
        Image resultImage = new DataDeclarationRenderer().getIcon(dataDeclaration);
        if (resultImage != null && this.isShadowed()) {
            resultImage = IconFactory.createGreyIcon(resultImage);
        }
        return resultImage;
    }

    public String getText() {
        DataDeclaration dataDeclaration = this.getDataDeclaration();
        return new DataDeclarationRenderer().getLabel(dataDeclaration);
    }

    public DataDeclaration getDataDeclaration() {
        return (DataDeclaration)this.getUserObject();
    }

    public boolean isPredefined() {
        return this.getDataDeclaration().isPredefinedDeclaration();
    }

    public boolean isFirstLevelDeclarationNode() {
        return this.getParent() instanceof DataDeclarationContainerTreeNode;
    }

    public ActionGroup createActions() {
        DataDeclarationContainerTreeNode parent;
        ActionGroup result = new ActionGroup();
        if (!this.isPredefined() && this.isFirstLevelDeclarationNode() && (parent = (DataDeclarationContainerTreeNode)this.getParent()).getDataDeclarationContainer().isMutableDeclarationContainer()) {
            result.add((BaseAction)new DataDeclarationEditAction(this));
            result.add((BaseAction)new DataDeclarationRemoveAction(this));
        }
        return result;
    }

    public Sequence<DataDeclaration> getDeclarationsPath() {
        ArrayList<DataDeclaration> result = new ArrayList<DataDeclaration>();
        TreeNode parentNode = this.getParent();
        if (parentNode != null && parentNode instanceof DataDeclarationTreeNode) {
            DataDeclarationTreeNode parentDataDeclarationTreeNode = (DataDeclarationTreeNode)parentNode;
            for (DataDeclaration element : parentDataDeclarationTreeNode.getDeclarationsPath()) {
                result.add(element);
            }
        }
        result.add(this.getDataDeclaration());
        return CollectionUtils.asSequence(result);
    }

    public String getToolTipText() {
        StringBuilder sb = new StringBuilder();
        CatalogType type = this.getDataDeclaration().getType();
        sb.append("<html><body>");
        sb.append("<b>").append(type.getText()).append("</b>:&nbsp;");
        sb.append(this.getText());
        sb.append("</body></html>");
        return sb.toString();
    }

    @Override
    public DataDeclarationTreeNode findDataDeclarationTreeNode(@NotNull DataDeclaration dataDeclaration) {
        return (DataDeclarationTreeNode)this.findChildByUserObject(dataDeclaration);
    }

    public boolean isShadowed() {
        TreeNode root = this.getRoot();
        DataDeclarationTreeNode rootDeclarationNode = this.getRootDeclarationNode(this);
        String rootDeclarationName = rootDeclarationNode.getDataDeclaration().getName();
        int rootDeclarationNodeLevel = rootDeclarationNode.getLevel();
        return this.hasChildrenDeclarationName(root, rootDeclarationName, rootDeclarationNodeLevel);
    }

    protected void onLoading() {
        this.buildTree();
    }

    private void buildTree() {
        for (DataDeclaration child : this.getDataDeclaration().getLocalDeclarations()) {
            DataDeclarationTreeNode childNode = new DataDeclarationTreeNode(child);
            this.add(childNode);
        }
    }

    private DataDeclarationTreeNode getRootDeclarationNode(@NotNull DataDeclarationTreeNode node) {
        DataDeclarationTreeNode element = node;
        while (element.getParent() instanceof DataDeclarationTreeNode) {
            element = (DataDeclarationTreeNode)element.getParent();
        }
        return element;
    }

    private boolean hasChildrenDeclarationName(@NotNull TreeNode root, @NotNull String name, int level) {
        List children = root.getChildren();
        for (TreeNode child : children) {
            int levelFound;
            DataDeclarationTreeNode dataDeclarationTreeNode;
            DataDeclaration dataDeclaration;
            if (!(child instanceof DataDeclarationTreeNode ? name.equals((dataDeclaration = (dataDeclarationTreeNode = (DataDeclarationTreeNode)child).getDataDeclaration()).getName()) && (levelFound = dataDeclarationTreeNode.getLevel()) < level : this.hasChildrenDeclarationName(child, name, level))) continue;
            return true;
        }
        return false;
    }
}

